#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "на devtest 40 минут",
  comment => "Ищет все кампании-кошельки и добавляет им элемент 'paused_by_day_budget_sms' во множество camp_options.sms_flags "
}

=cut

use Direct::Modern;

use Yandex::Retry;
use Yandex::DBTools;
use Yandex::DBShards;

use my_inc '..';

use ShardingTools;
use ScriptHelper;
use Settings;

my $LIMIT = 1000;

extract_script_params(
        'cid=i' => \my $only_cid,
    );

$log->out('START');

for my $shard ($only_cid ? get_shard(cid => $only_cid) : ppc_shards()) {
    unless ($shard) {
        $log->out("can't get shard for cid $only_cid");
        last;
    }
    update_in_shard($shard);
}

$log->out('FINISH');



sub update_in_shard {
    my ($shard) = @_;
    my $g = $log->msg_prefix_guard("[shard=$shard]");
    my $max_cid = get_one_field_sql(PPC(shard=>$shard), "SELECT max(cid) FROM campaigns") + 1;
    my $min_cid = 0;

    if ($only_cid) {
        $min_cid = $only_cid;
        $max_cid = $min_cid + 1;
    }

    while($min_cid < $max_cid) {
        my $g = relaxed_guard(times => 1);
        my $rows = get_all_sql(PPC(shard => $shard), "SELECT c.cid, co.sms_flags
                                                        FROM wallet_campaigns wc
                                                        	JOIN campaigns c ON c.cid = wc.wallet_cid
                                                            JOIN camp_options co ON co.cid = c.cid
                                                       WHERE c.cid >= ? and c.cid < ?
                                                         AND type = 'wallet' AND co.sms_flags NOT LIKE '%paused_by_day_budget_sms%'
                                                       ORDER BY c.cid
                                                       LIMIT $LIMIT", $min_cid, $max_cid);
        $log->out("updating wallets", $rows);
        last if !@$rows;
        do_update_table(PPC(shard => $shard), 'camp_options', {sms_flags__smod => {paused_by_day_budget_sms => 1}},
                           where => {cid => [ map { $_->{cid} } @$rows ]}
            );
        $min_cid = $rows->[-1]->{cid} + 1;
    }
}
