#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "5 sec",
  comment => ""
}

=cut

use Direct::Modern;

use Yandex::DBShards;
use Yandex::Shell;

use my_inc '..';

use ScriptHelper;
use Settings;

use RBACDirect;
use RBAC2::Extended;
use PrimitivesIds;

$log->out('START');

my $role = 'support';
my $login = 'yndx-vysevkov-support';
my $uid = get_uid(login => $login) || die "unknown login: $login";

my $rbac = RBAC2::Extended->get_singleton(1);
$log->out("drop_user for $uid, $role");
RBACDirect::rbac_drop_user($rbac, $uid, $role);

yash_system("$Settings::ROOT/protected/rbacCopyRolesToPpc.pl", "--uid" => $uid, "--shard-id" => get_shard(uid => $uid));

$log->out('FINISH');

