#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "2 секунды",
  comment => "Запустить скрипт с указанными параметрами: /var/www/ppc.yandex.ru/deploy/20170913_set_country_for_belarus_subclients.pl --data-file /var/www/ppc.yandex.ru/deploy/20170913_set_country_for_belarus_subclients.data"
}

=cut

use my_inc "..";

use Direct::Modern;

use Path::Tiny;

use ScriptHelper;
use Settings;
use Yandex::DBTools;
use Yandex::DBShards qw/SHARD_IDS/;

my $data_path;
extract_script_params(
    'data-file=s' => \$data_path,
);

$log->out('START');
my @client_id2reg_lines = path($data_path)->lines({ chomp => 1}) or $log->die("Can't open data file $data_path: $@");

for my $line (@client_id2reg_lines) {
    my ($client_id, $country_region_id) = split(';', $line);
    my $msg_prefix_guard = $log->msg_prefix_guard("[ClientID_$client_id]");

    $log->out("Region to set: $country_region_id");
    my $client_data = get_one_line_sql(PPC(ClientID => $client_id),
        "SELECT ClientID, country_region_id
           FROM clients
          WHERE ClientID = ?
        ", $client_id);
    unless ($client_data && %$client_data) {
        $log->out("Cannot find client with ClientID");
        next;
    }
    $log->out("Current country id: $client_data->{country_region_id}");
    do_update_table(PPC(ClientID => $client_data->{ClientID}), 'clients', {country_region_id => $country_region_id}, where => {ClientID => SHARD_IDS})
}

$log->out('FINISH');

