#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "10 секунд",
  comment => "отклоняем креативы с плохим фоном"
}

=cut

use JSON;
use YAML::Syck qw//;

use Direct::Modern;

use Yandex::TimeCommon qw/unix2mysql/;
use Yandex::Retry qw/relaxed_guard/;
use Yandex::DBTools;
use Yandex::DBShards;

use my_inc '..';

use ScriptHelper;
use Settings;
use PrimitivesIds qw/get_key2clientid/;
use BS::ResyncQueue qw/bs_resync/;

$YAML::Syck::ImplicitUnicode = 1;
my $DRY_RUN = 0;
my $SLEEP_COEF = 1;
use constant RESYNC_PRIORITY => 101;

my @creative_ids = (
1075010127, 1075016474, 1075024990, 1075063818, 1075063903, 1075063899, 1075063901, 1075063902, 1075063895, 1075064033,
1075064036, 1075064034, 1075064039, 1075064029, 1075064037, 1075064080, 1075064166, 1075064168, 1075064165, 1075064330,
1075064329, 1075064312, 1075064465, 1075064472, 1075105283, 1075120136, 1075122495, 1075122496, 1075125087, 1075125147,
1075125146, 1075125159, 1075125181, 1075125177, 1075125142, 1075125158, 1075125191, 1075125263, 1075125259, 1075125254,
1075125252, 1075125273, 1075125255, 1075125334, 1075125323, 1075125335, 1075125423, 1075125553, 1075125549, 1075125607,
1075125608, 1075168992, 1075168996, 1075168998, 1075169014, 1075169033, 1075169038, 1075169007, 1075169016, 1075168987,
1075168993, 1075168989, 1075169160, 1075169161, 1075169166, 1075169126, 1075169174, 1075169173, 1075169215, 1075169188,
1075169203, 1075169271, 1075169255, 1075169421, 1075169469, 1075170717, 1075170718, 1075170726, 1075171214, 1075171212,
1075171218, 1075171253, 1075171261, 1075174700, 1075189080, 1075189078, 1075189076, 1075189072, 1075189062, 1075189052,
1075189055, 1075189065, 1075189058, 1075189122, 1075189095, 1075189098, 1075189121, 1075189096, 1075189104, 1075189093,
1075189185, 1075189184, 1075189173, 1075189180, 1075189217, 1075189211, 1075189263, 1075189468, 1075245140, 1075245142,
1075245172, 1075278875, 1075278899, 1075278915, 1075279006, 1075279093, 1075279124, 1075279131, 1075279141, 1075279122,
1075279140, 1075279294, 1075279334, 1075279332, 1075279316, 1075279320, 1075279370, 1075279413, 1075279573, 1075279565,
1075279569, 1075279554, 1075279583, 1075279589, 1075279559, 1075279546, 1075279537, 1075279575, 1075279629, 1075279636,
1075279627, 1075279606, 1075279690, 1075279691, 1075279664, 1075279674, 1075279723, 1075279745, 1075279727, 1075279732,
1075279781, 1075279965, 1075286910, 1075286921, 1075286923, 1075286909, 1075286919, 1075287084, 1075287083, 1075287280,
1075287277, 1075287284, 1075287283, 1075287256, 1075287258, 1075287273, 1075287242, 1075287275, 1075287243, 1075287272,
1075287315, 1075287314, 1075288446, 1075288462, 1075288457, 1075288472, 1075288467, 1075288465, 1075288470, 1075288475,
1075288478, 1075288476, 1075288477, 1075288485, 1075288497, 1075288511, 1075288495, 1075288510, 1075288565, 1075288554,
1075288563, 1075288573, 1075288592, 1075288583, 1075288625, 1075288666, 1075290572, 1075290595, 1075290631, 1075290640,
1075290636, 1075290661, 1075355654, 1075355659, 1075355658, 1075355656, 1075356251, 1075356745, 1075356733, 1075356743,
1075359105, 1075359107, 1075360085, 1075360086, 1075370296, 1075370304, 1075370298, 1075370312, 1075370331, 1075370368,
1075370365, 1075370359, 1075370361, 1075370376, 1075370390, 1075370415, 1075370419, 1075370682, 1075370683, 1075370675,
1075370681, 1075374120, 1075374130, 1075374113, 1075374114, 1075374127, 1075374118, 1075374149, 1075374145, 1075374153,
1075374150, 1075374140, 1075374171, 1075374177, 1075374164, 1075374217, 1075374220, 1075374215, 1075374212, 1075374197,
1075374236, 1075374257, 1075374266, 1075374301, 1075374320, 1075379040, 1075381122, 1075381421, 1075384401, 1075388668,
1075388703, 1075388704, 1075390714, 1075390730, 1075390721, 1075390719, 1075390733, 1075390726, 1075390708, 1075390712,
1075390746, 1075390767, 1075390747, 1075390763, 1075390770, 1075390780, 1075390778, 1075390788, 1075390790, 1075390791,
1075390808, 1075390818, 1075390827, 1075390819, 1075390812, 1075390831, 1075390884, 1075390876, 1075390883, 1075390905,
1075390921, 1075390910, 1075390915, 1075390925, 1075390917, 1075390920, 1075390900, 1075390939, 1075390941, 1075390948,
1075390953, 1075390950, 1075390940, 1075390955, 1075390965, 1075390963, 1075391086, 1075391272, 1075391270, 1075391274,
1075391299, 1075391312, 1075391304, 1075391306, 1075391311, 1075391297, 1075391300, 1075391307, 1075391320, 1075391305,
1075391325, 1075391341, 1075391342, 1075391360, 1075391408, 1075391394, 1075391398, 1075391429, 1075391412, 1075391796,
1075391816, 1075391798, 1075391800, 1075391806, 1075391794, 1075391802, 1075391822, 1075391846, 1075391843, 1075391835,
1075391858, 1075391855, 1075391870, 1075391876, 1075391884, 1075391863, 1075391885, 1075391861, 1075391908, 1075391914,
1075391891, 1075391972, 1075391962, 1075392648, 1075392647, 1075392736, 1075392738, 1075392742, 1075392716, 1075392746,
1075392744, 1075392695, 1075392702, 1075392741, 1075392724, 1075392729, 1075392704, 1075392734, 1075392690, 1075392761,
1075392773, 1075392771, 1075392753, 1075392757, 1075392791, 1075392780, 1075397182, 1075397288, 1075397273, 1075397272,
1075397290, 1075397298, 1075397276, 1075397289, 1075397278, 1075397277, 1075397310, 1075397316, 1075397309, 1075397345,
1075397329, 1075397344, 1075397343, 1075397325, 1075397339, 1075397351, 1075397375, 1075397369, 1075397364, 1075397472,
1075400026, 1075400077, 1075400317, 1075400323, 1075400378, 1075400376, 1075400377, 1075400395, 1075400389, 1075400422,
1075400412, 1075400457, 1075400449, 1075400450, 1075400452, 1075400456, 1075400455, 1075400454, 1075400451, 1075401168,
1075401443, 1075401444, 1075401448, 1075401515, 1075409767, 1075409766, 1075409768, 1075409773, 1075409775, 1075409781,
1075409777, 1075409783, 1075409789, 1075409812, 1075409815, 1075409821, 1075409824, 1075409832, 1075409827, 1075409835,
1075409843, 1075409848, 1075409849, 1075409855, 1075409868, 1075417407, 1075417410, 1075461209, 1075461202, 1075486213,
1075486222, 1075486220, 1075486232, 1075488157, 1075492795, 1075492958, 1075492956, 1075492960, 1075493665, 1075493654,
1075595219, 1075595210, 1075595206, 1075595408, 1075595421, 1075595412, 1075595404, 1075600306, 1075602194, 1075609866,
1075628419, 1075628669, 1075629024, 1075629899, 1075630773, 1075630769, 1075630739, 1075631802, 1075632506, 1075632749,
1075632752, 1075632743, 1075633071, 1075633088, 1075633093, 1075633473, 1075633469, 1075659544, 1075659557, 1075659747,
1075659764, 1075659787, 1075659754, 1075659742, 1075659744, 1075659788, 1075659752, 1075659967, 1075659971, 1075667156,
1075667179, 1075667151, 1075667185, 1075667309, 1075667476, 1075667486, 1075667452, 1075667472, 1075667484, 1075667566,
1075667558, 1075667591, 1075667606, 1075667603, 1075667598, 1075667593, 1075668578, 1075668625, 1075668826, 1075668823,
1075668862, 1075668948, 1075670320, 1075674471, 1075686045, 1075688049, 1075688403, 1075688422, 1075688421, 1075688507,
1075688520, 1075688519, 1075688533, 1075688538, 1075688521, 1075688527, 1075688574, 1075688564, 1075688551, 1075688624,
1075688616, 1075692985, 1075693024, 1075693015, 1075693048, 1075693045, 1075693035, 1075693054, 1075693055, 1075693101,
1075693654, 1075693669, 1075693701, 1075693749, 1075693752, 1075693753, 1075693754, 1075693774, 1075693771, 1075693770,
1075693786, 1075693903, 1075694043, 1075694101, 1075694135, 1075694148, 1075694282, 1075694288, 1075694472, 1075694490,
1075694498, 1075694505, 1075694540, 1075694526, 1075694623, 1075694614, 1075694648, 1075708312, 1075714550, 1075714553,
1075714558, 1075714560, 1075714893, 1075716474, 1075716470, 1075716476, 1075716469, 1075716481, 1075717285, 1075717386,
1075717437, 1075717436, 1075717442, 1075717446, 1075717444, 1075717483, 1075717462, 1075717472, 1075717476, 1075717470,
1075717469, 1075717474, 1075717515, 1075717497, 1075717510, 1075717492, 1075717508, 1075717545, 1075717538, 1075717543,
1075717557, 1075717560, 1075717549, 1075717548, 1075719606, 1075719600, 1075719629, 1075719627, 1075719718, 1075720602,
1075720688, 1075720704, 1075720711, 1075720718, 1075720729, 1075720774, 1075720790, 1075720801, 1075720856, 1075720846,
1075720862, 1075721760, 1075729229, 1075729906, 1075729905, 1075730568, 1075730564, 1075730575, 1075730574, 1075730551,
1075730553, 1075730572, 1075730556, 1075730580, 1075730591, 1075730590, 1075730594, 1075730633, 1075730632, 1075730637,
1075730627, 1075730614, 1075730631, 1075730655, 1075730668, 1075730647, 1075730659, 1075730682, 1075730701, 1075732503,
1075732525, 1075732519, 1075732506, 1075732513, 1075732509, 1075732521, 1075732512, 1075732526, 1075732627, 1075732631,
1075732623, 1075732624, 1075732615, 1075732705, 1075732703, 1075732702, 1075732716, 1075732743, 1075732725, 1075732744,
1075732727, 1075732865, 1075732868, 1075732867, 1075732869, 1075732870, 1075732871, 1075732872, 1075732860, 1075732918,
1075732893, 1075732907, 1075732897, 1075732914, 1075732915, 1075732891, 1075732932, 1075732943, 1075732948, 1075732923,
1075732963, 1075732986, 1075733054, 1075733095, 1075733376, 1075734609, 1075734612, 1075734657, 1075734655, 1075734645,
1075734651, 1075734654, 1075734641, 1075734669, 1075734664, 1075734728, 1075734722, 1075734732, 1075734712, 1075734709,
1075734719, 1075734717, 1075734723, 1075734718, 1075734744, 1075734795, 1075734846, 1075736104, 1075736335, 1075736434,
1075736435, 1075736433, 1075739553, 1075739586, 1075739590, 1075739588, 1075739616, 1075739637, 1075739635, 1075739691,
1075739682, 1075740874, 1075742382, 1075742381, 1075742383, 1075742385, 1075742845, 1075743542, 1075744197, 1075744610,
1075744600, 1075744602, 1075744607, 1075750331, 1075750320, 1075750307, 1075750443, 1075750453, 1075750448, 1075750451,
1075750438, 1075750505, 1075750768, 1075752123, 1075752343, 1075753950, 1075755474, 1075766459, 1075766534, 1075766804,
1075766803, 1075768380, 1075768474, 1075768516, 1075768502, 1075768501, 1075768503, 1075768489, 1075768488, 1075768487,
1075768497, 1075768494, 1075768510, 1075768498, 1075768541, 1075768537, 1075768527, 1075768571, 1075768567, 1075768573,
1075768570, 1075768564, 1075768575, 1075768603, 1075768597, 1075768589, 1075768592, 1075768762, 1075768955, 1075768951,
1075768953, 1075768967, 1075768971, 1075769095, 1075769096, 1075769140, 1075769141, 1075769151, 1075769352, 1075769361,
1075769455, 1075769451, 1075769460, 1075771334, 1075774326, 1075774327, 1075774427, 1075774507, 1075774506, 1075774505,
1075774509, 1075779747, 1075779754, 1075779753, 1075785849, 1075785880, 1075785839, 1075785872, 1075785836, 1075785866,
1075785870, 1075785855, 1075785959, 1075785993, 1075785937, 1075785945, 1075785931, 1075785968, 1075785943, 1075785970,
1075786016, 1075786020, 1075786086, 1075786164, 1075786217, 1075786227, 1075786253, 1075791370, 1075791377, 1075791372,
1075791375, 1075791388, 1075791402, 1075791400, 1075791397, 1075791395, 1075791409, 1075791394, 1075791412, 1075791425,
1075791439, 1075791419, 1075791426, 1075791416, 1075791456, 1075791449, 1075791467, 1075791460, 1075791451, 1075791668,
1075791785, 1075804646, 1075804659, 1075804709, 1075805014, 1075804990, 1075805024, 1075804988, 1075805013, 1075805007,
1075804982, 1075804996, 1075805066, 1075805061, 1075805047, 1075805049, 1075808940, 1075809116, 1075809224, 1075809235,
1075809231, 1075809255, 1075809237, 1075809253, 1075809239, 1075809249, 1075809283, 1075809263, 1075809276, 1075809269,
1075809267, 1075809395, 1075809416, 1075809418, 1075809424, 1075809419, 1075809421, 1075809441, 1075820760, 1075821805,
1075823169, 1075824474, 1075826314, 1075826342, 1075826311, 1075826358, 1075826324, 1075826368, 1075826341, 1075826333,
1075826316, 1075826351, 1075826338, 1075826330, 1075826440, 1075826447, 1075826428, 1075826421, 1075826412, 1075826479,
1075826482, 1075826682, 1075826669, 1075826672, 1075826707, 1075826713, 1075826685, 1075826701, 1075826687, 1075826671,
1075826716, 1075826854, 1075826855, 1075826879, 1075826870, 1075829497, 1075829498, 1075829502, 1075830376, 1075830374,
1075831325, 1075831588, 1075831565, 1075831579, 1075831572, 1075831583, 1075831563, 1075831585, 1075831575, 1075831582,
1075831562, 1075832117, 1075832100, 1075832837, 1075836532, 1075839155, 1075845204, 1075845223, 1075845244, 1075845239,
1075845245, 1075845231, 1075845226, 1075845225, 1075845219, 1075845221, 1075845230, 1075845243, 1075845254, 1075845267,
1075845266, 1075845828, 1075845837, 1075845900, 1075845952, 1075846001, 1075846018, 1075846019, 1075846084, 1075846119,
1075846411, 1075846404, 1075846413, 1075846389, 1075846396, 1075846392, 1075846391, 1075846383, 1075846416, 1075846456,
1075846454, 1075846459, 1075846477, 1075846468, 1075846481, 1075856735, 1075856736, 1075856740, 1075862396, 1075862413,
1075862414, 1075862400, 1075862404, 1075862397, 1075862406, 1075862411, 1075862401, 1075862388, 1075862450, 1075862455,
1075862430, 1075862445, 1075862452, 1075862439, 1075862451, 1075862475, 1075862482, 1075862460, 1075862493, 1075862545,
1075862541, 1075862581, 1075866047, 1075866039, 1075866045, 1075866253, 1075866254, 1075866251, 1075866252, 1075866255,
1075868078, 1075868073, 1075868095, 1075868102, 1075868111, 1075868106, 1075868100, 1075868116, 1075868153, 1075868151,
1075868163, 1075868643, 1075868642, 1075868662, 1075868683, 1075868673, 1075868674, 1075868685, 1075868681, 1075868663,
1075868700, 1075868704, 1075868698, 1075868701, 1075868706, 1075868724, 1075868725, 1075868742, 1075868739, 1075868747,
1075868752, 1075868757, 1075868809, 1075868894, 1075869011, 1075896772, 1075896773, 1075896812, 1075896819, 1075896817,
1075896803, 1075896862, 1075896864, 1075896880, 1075896881, 1075896870, 1075896869, 1075896916, 1075896947, 1075896951,
1075896941, 1075897014, 1075897018, 1075897380, 1075897556, 1075897671, 1075897672, 1075897674, 1075899365, 1075917103,
1075917141, 1075917353, 1075917477, 1075917618, 1075917615, 1075917617, 1075936759, 1075936810, 1075936813, 1075936815,
1075936859, 1075937236, 1075937287, 1075937329, 1075937330, 1075940786, 1075940788, 1075952983, 1075958169, 1075964364,
1075967283, 1075969108, 1076079255, 1076079280, 1076088980, 1076127645, 1076127648, 1076129269, 1076129371, 1076129899,
1076129903, 1076129932, 1076129948, 1076130006, 1076131133, 1076131148, 1076131149, 1076131163, 1076131416, 1076131433,
1076131511, 1076131513, 1076131668, 1076131686, 1076131713, 1076131765, 1076131807, 1076131814, 1076131835, 1076131850,
1076131854, 1076133269, 1076133270, 1076133278, 1076133276, 1076133271, 1076133274, 1076135534, 1076135536, 1076135540,
1076135556, 1076135586, 1076135587, 1076135601, 1076135617, 1076135632, 1076139817, 1076147888, 1076149027, 1076149029,
1076149034, 1076149026, 1076149036, 1076149039, 1076149042, 1076149056, 1076149053, 1076149065, 1076149300, 1076149301,
1076149299, 1076149382, 1076149383, 1076149395, 1076149398, 1076149400, 1076181001, 1076181000, 1076181679, 1076181716,
1076181711, 1076181717, 1076181715, 1076181712, 1076244398, 1076244607, 1076244609, 1076373701, 1076374184, 1076377548,
1076377692, 1076377786, 1076378065, 1076378061, 1076378483, 1076379750, 1076379748, 1076431601, 1076431594, 1076431604,
1076431602, 1076431603, 1076431605, 1076431599, 1076431703, 1076431698, 1076435358, 1076435633, 1076435628, 1076437589,
1076437599, 1076437591, 1076439599, 1076439596, 1076443114, 1076443119, 1076443137, 1076443148, 1076443136, 1076443140,
1076443139, 1076443162, 1076443167, 1076443210, 1076443216, 1076443226, 1076443225, 1076443218, 1076443238, 1076443230,
1076443249, 1076443270, 1076443310, 1076443314, 1076443316, 1076443304, 1076443379, 1076443449, 1076444504, 1076444505,
1076447409, 1076447419, 1076447414, 1076447401, 1076447424, 1076447400, 1076447428, 1076447404, 1076447423, 1076447403,
1076447445, 1076447455, 1076447434, 1076447448, 1076447469, 1076447463, 1076447882, 1076447866, 1076447892, 1076447863,
1076447894, 1076447887, 1076447877, 1076499038, 1076499492, 1076511909, 1076511921, 1076512775, 1076514544, 1076516850,
1076519663, 1076528441, 1076528467, 1076528494, 1076528485, 1076528486, 1076528480, 1076528483, 1076528491, 1076528496,
1076528481, 1076528670, 1076528725, 1076528728, 1076528754, 1076528767, 1076537885, 1076537898, 1076537899, 1076537902,
1076537901, 1076538529, 1076538584, 1076538672, 1076538688, 1076538693, 1076538856, 1076539149, 1076539431, 1076539874,
1076543617, 1076543840, 1076543835, 1076543836, 1076543834, 1076543954, 1076543956, 1076543963, 1076543957, 1076555499,
1076555498, 1076555487, 1076555493, 1076555491, 1076555500, 1076555517, 1076555523, 1076555505, 1076555518, 1076555511,
1076555522, 1076555546, 1076555534, 1076555580, 1076555565, 1076555570, 1076555569, 1076555573, 1076555605, 1076555606,
1076559856, 1076559849, 1076559872, 1076559875, 1076559846, 1076559871, 1076561019, 1076561054, 1076561046, 1076561047,
1076561027, 1076561043, 1076561033, 1076561029, 1076561039, 1076562890, 1076562882, 1076562877, 1076562898, 1076562885,
1076562888, 1076564202, 1076564204, 1076564199, 1076564203, 1076564189, 1076564197, 1076565479, 1076565576, 1076565595,
1076565633, 1076565591, 1076565625, 1076565645, 1076565564, 1076565641, 1076565570, 1076565588, 1076565607, 1076565586,
1076565593, 1076565611, 1076565582, 1076565574, 1076565679, 1076565677, 1076565724, 1076565749, 1076565882, 1076568505,
1076568492, 1076568514, 1076568500, 1076568494, 1076568510, 1076568509, 1076569492, 1076570350, 1076570369, 1076582134,
1076582132, 1076582131, 1076582340, 1076582345, 1076589859, 1076589867, 1076589865, 1076589874, 1076590227, 1076590316,
1076590317, 1076590402, 1076590446, 1076590524, 1076590541, 1076590543, 1076590561, 1076591290, 1076591456, 1076591473,
1076591544, 1076591554, 1076591560, 1076618284, 1076618287, 1076618286, 1076618289, 1076618322, 1076618330, 1076618312,
1076618316, 1076618317, 1076618333, 1076618332, 1076619802, 1076622996, 1076622995, 1076623053, 1076625496, 1076626050,
1076626053, 1076626033, 1076626046, 1076626039, 1076626062, 1076626045, 1076626051, 1076626037, 1076626061, 1076626091,
1076626069, 1076626077, 1076626071, 1076626067, 1076626119, 1076626096, 1076626122, 1076626127, 1076626173, 1076626155,
1076626241, 1076626252, 1076626288, 1076631137, 1076631130, 1076631135, 1076631132, 1076631367, 1076631368, 1076631373,
1076632217, 1076632221, 1076632226, 1076632367, 1076632371, 1076632374, 1076632369, 1076632373, 1076632574, 1076632570,
1076632581, 1076632559, 1076632569, 1076632566, 1076632604, 1076632597, 1076632643, 1076632617, 1076632616, 1076632658,
1076632692, 1076632731, 1076632705, 1076632736, 1076634278, 1076638010, 1076638031, 1076638027, 1076638034, 1076638030,
1076638033, 1076638035, 1076638042, 1076638618, 1076638615, 1076638611, 1076638623, 1076638621, 1076638624, 1076638625,
1076638646, 1076638655, 1076638653, 1076638654, 1076638680, 1076638682, 1076638706, 1076638710, 1076638728, 1076638730,
1076638763, 1076638783, 1076638782, 1076638779, 1076638867, 1076638874, 1076638976, 1076639378, 1076639375, 1076639390,
1076639455, 1076639532, 1076639537, 1076639558, 1076639556, 1076639559, 1076639581, 1076645398, 1076645411, 1076645431,
1076645518, 1076645517, 1076645519, 1076671239, 1076672635, 1076672634, 1076674599, 1076674608, 1076674591, 1076674595,
1076674600, 1076674614, 1076674585, 1076674589, 1076674622, 1076674617, 1076674638, 1076674626, 1076674624, 1076674645,
1076674657, 1076674660, 1076674649, 1076674663, 1076674678, 1076674736, 1076674737, 1076674773, 1076674802, 1076674828,
1076677243, 1076677262, 1076677247, 1076677261, 1076677248, 1076677257, 1076677263, 1076677239, 1076677254, 1076677266,
1076677310, 1076677321, 1076678541, 1076680760, 1076685337, 1076685326, 1076685325, 1076685317, 1076685322, 1076685316,
1076685329, 1076685332, 1076685330, 1076685370, 1076685349, 1076685347, 1076685368, 1076685369, 1076685373, 1076686026,
1076686057, 1076686059, 1076686054, 1076686067, 1076686069, 1076686058, 1076686050, 1076686071, 1076686051, 1076686053,
1076691080, 1076691087, 1076691086, 1076691081, 1076691082, 1076691967, 1076691988, 1076691977, 1076691972, 1076691983,
1076691978, 1076691971, 1076691997, 1076692006, 1076692045, 1076692046, 1076692033, 1076692029, 1076692028, 1076694464,
1076694468, 1076694475, 1076694478, 1076694484, 1076694507, 1076694511, 1076694548, 1076694549, 1076694587, 1076694589,
1076694647, 1076694669, 1076694734, 1076694732, 1076694739, 1076697778, 1076717257, 1076717258, 1076717260, 1076717691,
1076717696, 1076717695, 1076717829, 1076717837, 1076717827, 1076717840, 1076717834, 1076717821, 1076717832, 1076717825,
1076717820, 1076717850, 1076717841, 1076717842, 1076717860, 1076717893, 1076717874, 1076717897, 1076717880, 1076717908,
1076717999, 1076721197, 1076721195, 1076724198, 1076724212, 1076724224, 1076724207, 1076724215, 1076724205, 1076724229,
1076726943, 1076726994, 1076730565, 1076733246, 1076735041, 1076735166, 1076752135, 1076752148, 1076752780, 1076752784,
1076752783, 1076752785, 1076752790, 1076752786, 1076752845, 1076752867, 1076752874, 1076752855, 1076752869, 1076752870,
1076752895, 1076752893, 1076752898, 1076753021, 1076753027, 1076753046, 1076753034, 1076753031, 1076753039, 1076753041,
1076753032, 1076753595, 1076753598, 1076753597, 1076753599, 1076758592, 1076759796, 1076759797, 1076759795, 1076759809,
1076759811, 1076759815, 1076759839, 1076759849, 1076759844, 1076759847, 1076759856, 1076759866, 1076759889, 1076759883,
1076759886, 1076759901, 1076759907, 1076759910, 1076759912, 1076759925, 1076759931, 1076759934, 1076759937, 1076760584,
1076764635, 1076764643, 1076764651, 1076764655, 1076764650, 1076764658, 1076765971, 1076765985, 1076766456, 1076766459,
1076766466, 1076766469, 1076766484, 1076766503, 1076766505, 1076766509, 1076766513, 1076766531, 1076766527, 1076766530,
1076766528, 1076768844, 1076768847, 1076770069, 1076770067, 1076770062, 1076770057, 1076770046, 1076770078, 1076770076,
1076770240, 1076770254, 1076770248, 1076770242, 1076770560, 1076774333, 1076774375, 1076774371, 1076774595, 1076774587,
1076774592, 1076808946, 1076809160, 1076811405, 1076815042, 1076815044, 1076815043, 1076817138, 1076817124, 1076817137,
1076817143, 1076817148, 1076817139, 1076817130, 1076817129, 1076817128, 1076817141, 1076817125, 1076817121, 1076817170,
1076817151, 1076817175, 1076817160, 1076817163, 1076817197, 1076817211, 1076817222, 1076817221, 1076825285, 1076825284,
1076825304, 1076825297, 1076825315, 1076825365, 1076825370, 1076825377, 1076825379, 1076825406, 1076825973, 1076825977,
1076826106, 1076826207, 1076826208, 1076826231, 1076826249, 1076826461, 1076826463, 1076826466, 1076826541, 1076827364,
1076827366, 1076827369, 1076827368, 1076827393, 1076827397, 1076827396, 1076827406, 1076836461, 1076836562, 1076837040,
1076837450, 1076839393, 1076840839, 1076841469, 1076842806, 1076854783, 1076854907, 1076854919, 1076854941, 1076854945,
1076854946, 1076854948, 1076854954, 1076854975, 1076854983, 1076854985, 1076854981, 1076854992, 1076854997, 1076855005,
1076855002, 1076855019, 1076855021, 1076855037, 1076855047, 1076856701, 1076857022, 1076861049, 1076865303, 1076865302,
1076865305, 1076865300, 1076865506, 1076865514, 1076865524, 1076865554, 1076865566, 1076865571, 1076877220, 1076877719,
1076877717, 1076877716, 1076877718, 1076877750, 1076877736, 1076877735, 1076879083, 1076879078, 1076879081, 1076879077,
1076879091, 1076879092, 1076879114, 1076879107, 1076879106, 1076879112, 1076879100, 1076879111, 1076879110, 1076879102,
1076879098, 1076879109, 1076879142, 1076879146, 1076879157, 1076879178, 1076879161, 1076879240, 1076879268, 1076879484,
1076879856, 1076888697, 1076906539, 1076909132, 1076909268, 1076909264, 1076909254, 1076909312, 1076909311, 1076909395,
1076909437, 1076909430, 1076909407, 1076909389, 1076909425, 1076909421, 1076909470, 1076909455, 1076909472, 1076909623,
1076909640, 1076909651, 1076909642, 1076909828, 1076909831, 1076909857, 1076909840, 1076909839, 1076909855, 1076909835,
1076909884, 1076909890, 1076909869, 1076909883, 1076909864, 1076909885, 1076909916, 1076909897, 1076909907, 1076909912,
1076909917, 1076909899, 1076909947, 1076909940, 1076909965, 1076910045, 1076910055, 1076910077, 1076910083, 1076910619,
1076910618, 1076912259, 1076912275, 1076912777, 1076912779, 1076912785, 1076915080, 1076915100, 1076915104, 1076915102,
1076915136, 1076915140, 1076915138, 1076915205, 1076915213, 1076915215, 1076915214, 1076947856, 1076947875, 1076947866,
1076947864, 1076947869, 1076947878, 1076947870, 1076947868, 1076947871, 1076947867, 1076947863, 1076949586, 1076949587,
1076949616, 1076949756, 1076960379, 1076960390, 1076960389, 1076960400, 1076960475, 1076960477, 1076960462, 1076960486,
1076960512, 1076960502, 1076960508, 1076960528, 1076960581, 1076960664, 1076960666, 1076960813, 1076960891, 1076960892,
1076975947, 1076975934, 1076975936, 1076975940, 1076975968, 1076976058, 1076976099, 1076976111, 1076976113, 1076976091,
1076976097, 1076976087, 1076976075, 1076976173, 1076976150, 1076976175, 1076976142, 1076976200, 1076976215, 1076976190,
1076976223, 1076976240, 1076976336, 1076976400, 1076977138, 1076977148, 1076977334, 1076977344, 1076977350, 1076977348,
1076977367, 1076978473, 1076982028, 1076982882, 1076982880, 1076982915, 1076982913, 1076982968, 1076982960, 1076982956,
1076982958, 1076982977, 1076983011, 1076983034, 1076983036, 1076983022, 1076983038, 1076983080, 1076983092, 1076983164,
1076983168, 1076983232, 1076983287, 1076983236, 1076983349, 1076983389, 1076983402, 1077012955, 1077021377, 1077022836,
1077025700, 1077031068, 1077033901, 1077033991, 1077034308, 1077036498, 1077037477, 1077062265, 1077067720, 1077069137,
1077073923, 1077074191, 1077074194, 1077074231, 1077085354, 1077085955, 1077169217, 1077169429, 1077214360
);

$log->out('START');

my $banners = get_all_sql(PPC(creative_id => \@creative_ids), [
    "select b.bid, bp.banner_creative_id, b.cid, b.statusActive
    from banners b join banners_performance bp using(bid)",
    where => {
        'bp.creative_id' => SHARD_IDS
        'bp.statusModerate__ne' => 'No',
    }
]);
    
$log->out(sprintf("%d banners", scalar @$banners));


foreach_shard bid => $banners, chunk_size => 100, sub {
    my ($shard, $chunk) = @_;
    decline_banners($shard, $chunk);
};


$log->out('FINISH');
 
sub decline_banners {
    my ($shard, $banners) = @_;

    for my $banner (@$banners) {
        $banner->{reason} = [{id => 366}];
    }

    my $bid_client_id = get_key2clientid(bid => [map { $_->{bid} } @$banners]);
    my $mysql_now = unix2mysql(time());
    my (@to_insert, @banner_creative_id, @resync);
    for my $banner (@$banners) {
        push @banner_creative_id, $banner->{banner_creative_id};
        push @to_insert, [
            'video_addition',
            $banner->{banner_creative_id},
            $bid_client_id->{$banner->{bid}},
            $banner->{cid},
            'Yes',
            'No',
            'No',
            $mysql_now,
            YAML::Syck::Dump($banner->{reasons}),
        ];
        push @resync, {
            cid => $banner->{cid},
            bid => $banner->{bid},
            priority => $banner->{statusActive} eq 'Yes' ? RESYNC_PRIORITY : int(0.8 * RESYNC_PRIORITY)
        };
        $log->out("will update banner " . to_json($banner));
    }

    if (!$DRY_RUN) {
        my $relax = relaxed_guard(times => $SLEEP_COEF);
        do_mass_insert_sql(PPC(shard => $shard),
          q[INSERT mod_reasons(type, id, ClientID, cid, statusSending, statusModerate, statusPostModerate, timeCreated, reason) VALUES %s
            ON DUPLICATE KEY UPDATE statusSending = 'Yes', statusModerate = 'No', statusPostModerate = 'No',
                                    timeCreated = VALUES(timeCreated), reason = VALUES(reason)],
          \@to_insert);
        do_update_table(PPC(shard => $shard),
          banners_performance => {
              statusModerate => 'No'
          }, where => {banner_creative_id => \@banner_creative_id});
        bs_resync(\@resync);
    }
}
