#!/usr/bin/perl

=head1 DEPLOY

# approved by ppalex
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "1 секунда",
  script => "/var/www/ppc.yandex.ru/deploy/20171006_fix_status_postmoderate.pl --data-file /var/www/ppc.yandex.ru/deploy/20171006_fix_status_postmoderate.data"
}

=cut


use Direct::Modern;

use my_inc '..';

use Settings;
use ScriptHelper;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Retry qw/relaxed/;

use Path::Tiny;

my $SLEEP_COEF = 0.5;
my $data_path;
extract_script_params(
    'sleep-coef' => \$SLEEP_COEF,
    'data-file=s' => \$data_path,
);

$log->out('START');

my @pids = path($data_path)->lines({ chomp => 1}) or $log->die("Can't open data file $data_path: $@");
$log->out('Got ' . scalar(@pids) . ' pids');

foreach_shard pid => \@pids, chunk_size => 1_000, with_undef_shard => 1, sub {
    my ($shard, $pids_chunk) = @_;

    if (!$shard) {
        $log->out('unknown shard for pids:', $pids_chunk);
        return;
    }

    my $log_prefix_guard = $log->msg_prefix_guard("[shard_$shard]");

    relaxed times => $SLEEP_COEF, sub {
        $log->out('Fixing pids:', $pids_chunk);
        my $updated_rows_cnt = do_update_table(PPC(shard => $shard), 'phrases', {statusPostModerate => 'Yes', statusBsSynced => 'No'},
                                                                      where => {pid => $pids_chunk, statusModerate => 'Yes', statusPostModerate => 'No'}) + 0;
        $log->out("Updated $updated_rows_cnt rows");
    };
};

$log->out('FINISH');
