#!/usr/bin/perl

=head1 DEPLOY

# approved by liosha
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "10 минут",
  comment => 'можно перезапускать',
}

=cut

use Direct::Modern;
use my_inc '..';

use Yandex::DBTools;
use Direct::Campaigns;

use ShardingTools;
use ScriptHelper (log_warn => 1);
use Settings;


my $CHUNK_SIZE = 200;

extract_script_params(
    'cid=i' => \my @only_cids,
);


$log->out('START');

my @shards = ppc_shards();

my %cond_invalid = (
    type => [qw/ text mobile_content dynamic mcbanner performance /],
    _OR => [
        _AND => {
            is_search_stop => 1,
            platform__ne => "context",
        },
        _AND => {
            dontShowYacontext => "Yes",
            platform__ne => "search",
        },
        _AND => {
            strategy_name => 'default',
            _OR => {
                autobudget => 'Yes',
                strategy_no_premium => 'highest_place',
            },
        },
    ],
);

SHARD:
for my $shard (@shards) {
    $log->out("processing shard #$shard");
    my $min_cid = 0;
    while (1) {
        my $cids = get_one_column_sql(PPC(shard => $shard), [
                "SELECT cid
                FROM campaigns c
                JOIN camp_options co USING(cid)",
                WHERE => {
                    %cond_invalid,
                    cid__gt => $min_cid,
                    (@only_cids ? (cid => \@only_cids) : ()),
                },
                'ORDER BY cid',
                LIMIT => $CHUNK_SIZE,
            ]);
        last if !@$cids;
        $min_cid = $cids->[-1];

        $log->out(sprintf "shard #$shard: going to process %d campaigns (@$cids)", scalar @$cids);

        my %update_camp;
        my $campaigns = Direct::Campaigns->get($cids);
        for my $camp (@{$campaigns->items}) {
            $log->out(sprintf "shard #$shard: cid %d -- %s %s %s",
                $camp->id, $camp->strategy_name, $camp->_strategy_data, $camp->_platform,
            );
            $update_camp{$camp->id} = {
                strategy_name => $camp->strategy_name,
                strategy_data => $camp->_strategy_data,
                platform => $camp->_platform,
            };
        }

        my $updated_camp = do_mass_update_sql(PPC(shard => $shard),
            'campaigns JOIN camp_options USING(cid)', cid => \%update_camp,
            where => \%cond_invalid,
        );
        $log->out("shard #$shard: updated $updated_camp records");
#        use YAML; die Dump \%update;
    }
}

$log->out('FINISH');

