#!/usr/bin/perl

=head1 DEPLOY

# approved by ppalex
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "2 минуты на devtest, в продакшене ожидается секунд 15",
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;
use ShardingTools;

$log->out('START');

for my $shard (ppc_shards()) {
    my $guard = $log->msg_prefix_guard("[shard $shard]");
    $log->out("fetching copied camps with wrong sendWarn value");
    my $to_fix = get_one_column_sql(PPC(shard => $shard), ['SELECT cid FROM campaigns JOIN camp_options USING(cid)', 
                                    WHERE => {
                                        type => 'mcbanner',
                                        copiedFrom__gt => 0,
                                        sendWarn => "Yes",
                                    }]);
    $log->out({cid_to_fix => $to_fix});
    next unless @$to_fix;

    my $res = do_update_table(PPC(shard => $shard), 'camp_options', {sendWarn => 'No'}, where => {cid => $to_fix, sendWarn => "Yes"});
    $log->out("updated $res rows");
}

$log->out('FINISH');

