#!/usr/bin/perl

=head1 DEPLOY

# approved by ppalex,hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "минута-две на devtest",
  comment => "можно запускать с --dry-run для проверки данных"
}

=cut

use Direct::Modern;

use JSON;

use Yandex::DBTools;
use Yandex::ListUtils qw/nsort/;

use my_inc '..';

use ScriptHelper;
use Settings;
use ShardingTools qw/ppc_shards/;

my $DRY_RUN;
extract_script_params(
    'dry-run' => \$DRY_RUN,
);

$log->out('START');

if ($DRY_RUN) {
    $log->out("dry-run mode");
}

for my $shard (ppc_shards()) {
    my $log_prefix_guard = $log->msg_prefix_guard("[shard $shard]");

    $log->out("fetch conditions and goals");

    my ($conditions, $id2goals);
    do_sql(PPC(shard => $shard), "SET TRANSACTION ISOLATION LEVEL REPEATABLE READ");
    do_in_transaction {
        do_sql(PPC(shard => $shard), "SET GROUP_CONCAT_MAX_LEN = 1000000000");
        $conditions = get_hash_sql(PPC(shard => $shard), 'SELECT ret_cond_id, condition_json FROM retargeting_conditions');
        $id2goals = get_hash_sql(PPC(shard => $shard), 'SELECT ret_cond_id, GROUP_CONCAT(goal_id) FROM retargeting_goals GROUP BY ret_cond_id');
    };

    my @ret_cond_id_to_fix;

    $log->out("check conditions and goals");
    for my $ret_cond_id (nsort keys %$conditions) {
        my $actuals_goals = get_goals_from_json($conditions->{$ret_cond_id});
        
        my @unused = grep { !exists $actuals_goals->{$_} } split(qr/,/, $id2goals->{$ret_cond_id} // '');
        
        if (@unused) {
            $log->out({ret_cond_id => $ret_cond_id, unused_goals => \@unused});
            push @ret_cond_id_to_fix, $ret_cond_id;
        }
    }

    if (!@ret_cond_id_to_fix) {
        $log->out("goals and conditions are consistent");
        next;
    }


    $log->out("going to check again " . scalar(@ret_cond_id_to_fix) . ' conditions');
    for my $ret_cond_id (@ret_cond_id_to_fix) {
        $log->out("checking goals in ret_cond_id $ret_cond_id");


        do_in_transaction {
            my $condition_json = get_one_field_sql(PPC(shard => $shard), 'SELECT condition_json FROM retargeting_conditions WHERE ret_cond_id = ? LOCK IN SHARE MODE' , $ret_cond_id);
            my $goals = get_all_sql(PPC(shard => $shard), 'SELECT * FROM retargeting_goals WHERE ret_cond_id = ? LOCK IN SHARE MODE', $ret_cond_id);

            my $actuals_goals = get_goals_from_json($condition_json);
            my @to_delete = grep { !exists $actuals_goals-> { $_->{goal_id} } } @$goals;
            if (@to_delete) {
                $log->out({delete_goals => \@to_delete});
                my @ids = map {$_->{goal_id}} @to_delete;
                my $res = '-';

                unless ($DRY_RUN) {
                    $res = do_delete_from_table(PPC(shard => $shard), 'retargeting_goals', where => {ret_cond_id => $ret_cond_id, goal_id => \@ids});
                }
                $log->out("deleted $res rows");
            } else {
                $log->out("nothing to delete");
            }
        };
    }
    

}

$log->out('FINISH');

exit;

sub get_goals_from_json {
    my $json = shift;

    my %actuals_goals = map {
        $_ => undef
    } grep {
        $_
    } map {
        $_->{goal_id}
    } map {
        @$_
    } map {
        $_->{goals}
    } @{
        from_json( $json )
    };

    return \%actuals_goals;
}
