#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "секунда-другая",
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;
use RBAC2::Extended;
use RBACElementaryOld qw/rbac_get_chief_rep_of_client/;

my $OPERATOR_UID = 1;

my $UID = 5165919;
my $CLIENT_ID = 338812;

my ($DRY_RUN);
extract_script_params(
    'dry-run' => \$DRY_RUN,
);

my $rbac = eval { RBAC2::Extended->get_singleton($OPERATOR_UID) }
    or $log->die("Can't connect to RBAC: $@");

$log->out('START');

$log->out("fetch clientid for uid from RBAC");
my $BAD_CLIENT_ID = $rbac->GetClientIdByUid($UID, 'RBAC_Client');

$log->out("RBAC clientid for uid $UID is $BAD_CLIENT_ID");
if ($BAD_CLIENT_ID == $CLIENT_ID) {
    $log->out("client already fixed, exitting");
    exit;
}

my $cids = get_one_column_sql(PPC(uid => $UID), 'SELECT cid FROM campaigns WHERE uid = ?', $UID);
$log->out("Client campaigns: " . join(" ", @$cids));

my $errorcode;
do_in_transaction {

    $log->out("let's RBAC_DropNSCampaign for ClientID: $BAD_CLIENT_ID and uid: $UID");
    $errorcode = $rbac->Handle('RBAC_DropNSCampaign', {
            client_uid => $UID,
            client_id  => $BAD_CLIENT_ID,
            objects => $cids
    });
    check_error_code();

    $log->out("let's RBAC_DropClient for ClientID: $BAD_CLIENT_ID");
    $errorcode = $rbac->Handle('RBAC_DropClient', {client_id => $BAD_CLIENT_ID});
    check_error_code(); 

    $log->out("check RBAC_Login rights for uid: $UID");
    # use errorcode, expected 0 - no access
    $errorcode = $rbac->HasAccess($UID, 'RBAC_Login', 'System');
    check_error_code();

    $log->out("let's RBAC_CreateClient for ClientID: $CLIENT_ID and uid: $UID");
    $errorcode = $rbac->Handle('RBAC_CreateClient', {
              uid       => $UID,
              client_id => $CLIENT_ID,
        });
    check_error_code();

    $log->out("let's RBAC_CreateNSCampaign for ClientID: $CLIENT_ID and uid: $UID");
    $errorcode = $rbac->Handle('RBAC_CreateNSCampaign', {
        client_uid => $UID,
        client_id  => $CLIENT_ID,
        objects    => $cids,
    });
    check_error_code();

    $log->out("check new chief rep for ClientID: $CLIENT_ID");
    my $new_chief = rbac_get_chief_rep_of_client($rbac, $CLIENT_ID);
    if ($new_chief == $UID) {
        $log->out("chief rep fixed");
    } else {
        $log->die("unexpected new chief_rep for ClientID: $CLIENT_ID - $new_chief");
    }

    if ($DRY_RUN) {
        $log->die("break transactions, because enabled dry-run mode");
    } else {
        $log->out("commit transactions");
        $errorcode = $rbac->Commit();
        check_error_code();
    }
};

$log->out('FINISH');

exit;

sub check_error_code {
    $log->out("errorcode $errorcode");
    if (!$DRY_RUN && $errorcode)  {
        $log->die("bad errorcode, stop");
    }
}

