#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "1 секунда",
  script => "/var/www/ppc.yandex.ru/deploy/20171026_fix_rbac_rights_on_campaigns.pl --cid 31039279"
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Retry;

use my_inc '..';

use RBAC2::Extended;
use RBACDirect;
use ScriptHelper;
use Settings;

my $SLEEP_COEFF = 3;
extract_script_params(
    'sleep-coeff=i' => \$SLEEP_COEFF,
    'cid=i' => \my @cids,
);

$log->out('START');

foreach_shard cid => \@cids, chunk_size => 1_000, with_undef_shard => 1, sub {
    my ($shard, $cids_chunk) = @_;
    if (!$shard) {
        $log->msg_prefix(undef);
        $log->out({ERROR_cids_without_shard => $cids_chunk});
    } else {
        my $log_prefix_guard = $log->msg_prefix_guard("[shard $shard]");

        my $camps = get_all_sql(PPC(shard => $shard), [
                                    'SELECT STRAIGHT_JOIN c.cid, c.uid, c.manageruid, c.agencyuid, c.agencyid, c.currency',
                                    ', u.login, u.clientid',
                                    'FROM campaigns c',
                                    'JOIN users u ON u.uid = c.uid',
                                    WHERE => {
                                        'c.cid' => $cids_chunk,
                                        'c.statusEmpty' => 'No',
                                    },
                                ]);

        $log->out('Check RBAC rights');
        for my $camp (@$camps) {
            relaxed times => $SLEEP_COEFF, sub {
                my ($rbac_error, $need_fix);
                eval {
                    my $rbac = eval { RBAC2::Extended->get_singleton(1) } or $log->die("Error initialising RBAC: $@");

                    $log->out("check RIGHTS on $camp->{cid} ($camp->{login})");
                    my $client_lookup = $rbac->ExCheck($camp->{uid}, ["RBAC_Lookup"], [$camp->{cid}]);
                    my $rights_ok = $client_lookup && @$client_lookup;

                    if ($rights_ok) {
                        $log->out("$camp->{cid}: rights OK - SKIP");
                    } else {
                        $need_fix = 1;
                        $log->out("$camp->{cid}: NO RIGHTS - NEED FIX");
                        $camp->{lookup} = 'FAILED';

                        if ($camp->{agencyuid}) {
                            $rbac_error = rbac_save_camp_for_agency($rbac, $camp->{agencyuid}, $camp->{uid}, $camp->{cid});
                            $camp->{saved_for} = 'AGENCY';
                        } elsif ($camp->{manageruid}) {
                            $rbac_error = rbac_save_camp_for_manager($rbac, $camp->{manageruid}, $camp->{uid}, $camp->{cid});
                            $camp->{saved_for} = 'MANAGER';
                        } else {
                            $rbac_error = rbac_save_camp($rbac, $camp->{uid}, $camp->{cid});
                            $camp->{saved_for} = 'CLIENT';
                        }

                        $camp->{rbac_error} = $rbac_error if $rbac_error;
                    }
                };
                if ($need_fix) {
                    $camp->{eval_error} = $@ if $@;
                    $camp->{fixup} = $rbac_error || $@ ? 'FAILED' : 'OK';
                    $log->out($camp);
                }
            };
        }
    }
};

$log->out('FINISH');
