#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'ppalex',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "30 минут",
    }
  ]
}

=cut


use Direct::Modern;

use Path::Tiny qw/path/;
use JSON;

use Yandex::DBTools;
use Yandex::IDN qw/idn_to_ascii/;

use my_inc '..';

use BS::ResyncQueue;
use ScriptHelper 'Yandex::Log' => 'messages';
use Settings;

my $data_path;
extract_script_params(
    'data-file=s' => \$data_path,
);
$data_path //= my_inc::path('./20171101_correct_mirror_for_rtru_subdomain.data');


$log->out('START');

my $data_file = path($data_path) or $log->die("Can't open data file $data_path: $@");
my $data = from_json($data_file->slurp_utf8);

my @rows = map {[idn_to_ascii($_->[0]), idn_to_ascii($_->[1]), 'Auto']} @$data;

$log->out("row for insert: ".to_json($_)) for @rows;
my $res = do_mass_insert_sql(PPCDICT, "INSERT INTO mirrors_correction (domain, redirect_domain, correction_type)
                                       VALUES %s ON DUPLICATE KEY UPDATE redirect_domain=VALUES(redirect_domain), correction_type=VALUES(correction_type)", \@rows);

$log->out("inserted $res rows");

my @domains = map {$_->[0]} @rows;
foreach my $domain (@domains) {
    my $resync_result = BS::ResyncQueue::bs_resync_banners_by_domain($domain, priority => BS::ResyncQueue::PRIORITY_MANUAL_DOMAIN_MIRROR_CORRECTION);
    $log->out($resync_result->{bid_count}." banners from ".$resync_result->{cid_count}." campaigns added to bs resync queue for domain ".$domain);
}

$log->out('FINISH');
