#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '5 секунд на devtest',
  comment => 'убираем у всех субклиентов право создавать самоходные кампании
скрипт можно перезапускать',
}

=head1 DESCRIPTION

    Отбирает у всех субклиентов право создавать самоходные кампании

    Пример запуска миграции из корня беты
    LOG_TEE=1 ./deploy/20171119_deny_create_scamp_to_all_subclients.pl --client-id 1231515

    Если не указывать --client-id, будут обработаны все клиенты

=cut

use Direct::Modern;

use Yandex::DBShards;
use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;
use ShardingTools;

my $client_id;
extract_script_params(
    'client-id=i' => \$client_id,
);

$log->out('START');

my %client_id_sql;
my $client_shard;
if ($client_id) {
    $client_shard = get_shard(ClientID => $client_id);
    unless ($client_shard) {
        $log->die("Can't find client $client_id in any shard!");
    }
    $client_id_sql{ClientID} = $client_id;
    $log->out("Working only on ClientID $client_id");
}

for my $shard ($client_shard ? $client_shard : ppc_shards()) {
    my $guard = $log->msg_prefix_guard("[shard $shard]");
    $log->out("reading all free clients left");
    my $to_fix = get_one_column_sql(PPC(shard => $shard), ['SELECT ClientID FROM clients',
                                    WHERE => {
                                        allow_create_scamp_by_subclient => 'Yes',
                                        %client_id_sql,
                                    }]);
    $log->out({ClientID => $to_fix});
    next unless @$to_fix;

    my $res = do_update_table(PPC(shard => $shard), 'clients', {allow_create_scamp_by_subclient => 'No'}, where => {ClientID => $to_fix});
    $log->out("updated $res rows");
}

$log->out('FINISH');

