#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
[
    {
        type => 'script',
        when => 'after',
        time_estimate => '1 минута на devtest на всех шардах',
        comment => 'проставляем для старых условий retargeting_conditions_type как metrika_goals',
    },
    {
        type => 'sql',
        webstop => "0",
        db => "ppc:all",
        when => 'after',
        time_estimate => '< 1 минуты на devtest на всех шардах. Проверить что 0 == select count(*) from retargeting_conditions where retargeting_conditions_type is null',
        sql => "alter table retargeting_conditions change column retargeting_conditions_type `retargeting_conditions_type` enum('interests','metrika_goals','dmp') not null"
    }
]
=cut

use Direct::Modern;

use my_inc '..';

use Settings;
use ScriptHelper;
use ShardingTools;

use Yandex::DBTools;
use Yandex::ListUtils;
use Yandex::Retry qw/relaxed/;

my $SLEEP_COEF = 0.5;
extract_script_params(
    'sleep-coef' => \$SLEEP_COEF,
);

$log->out('START');

for my $shard (ppc_shards()) {
    my $guard = $log->msg_prefix_guard("[shard_$shard]");
    $log->out("selecting retargeting_conditions with retargeting_conditions_type is NULL");
    my $ret_cond_ids = get_one_column_sql(PPC(shard => $shard), "SELECT ret_cond_id FROM retargeting_conditions where retargeting_conditions_type is NULL");
    $log->out(sprintf("got %s ret_cond_ids", scalar(@$ret_cond_ids)));
    for my $chunk (chunks($ret_cond_ids, 1_000)) {
        relaxed times => $SLEEP_COEF, sub {
            $log->out("updating next retargeting_conditions chunk");
            my $affected_rows = do_update_table(PPC(shard => $shard), "retargeting_conditions", 
                                                                      {retargeting_conditions_type => 'metrika_goals'}, 
                                                                      where => {ret_cond_id => $chunk});
            $log->out(sprintf("affected %d rows", $affected_rows+0));
        };
    }
}

$log->out('FINISH');
