#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "3 минуты на девтест",
    }
  ],
  approved_by => 'lena-san'
}

=cut

use Direct::Modern;

use JSON;
use Path::Tiny;

use Yandex::DBShards;
use Yandex::DBTools;
use Yandex::ListUtils;

use my_inc '..';

use ScriptHelper;
use Settings;
use MinusWords;
use MinusWordsTools;

$log->out('START');

$log->out("load data from yt-file");
my $data_path = my_inc::path('./20171214_restore_minus_words_from_yt.data');
my @lines = path($data_path)->lines({ chomp => 1}) or $log->die("Can't open data file $data_path: $@");
$log->out("got ". scalar(@lines) ." from yt-file");

my %to_check;

for my $line (@lines) {
    my $row = decode_json($line);
    next if !$row->{minus_words};

    $to_check{$row->{cid}} = MinusWordsTools::minus_words_str2array($row->{minus_words});
}
$log->out("got " . scalar(keys(%to_check)) . " cids for check");


$log->out("load data from clickhouse-file");
$data_path = my_inc::path('./20171214_restore_minus_words_from_clickhouse.data');
@lines = path($data_path)->lines({ chomp => 1}) or $log->die("Can't open data file $data_path: $@");
$log->out("got ". scalar(@lines) ." from clickhouse-file");

for my $line (@lines) {
    my $row = decode_json($line);
    if (!$row->{minus_words}) {
        $log->out({strange_row => $line});
        next;
    }

    $to_check{$row->{cid}} = MinusWordsTools::minus_words_str2array($row->{minus_words});
}

$log->out("new count: " . scalar(keys(%to_check)) . " cids for check");

my $skip_cids = get_one_column_sql(PPC(cid => [keys %to_check]), ["SELECT cid FROM camp_options", WHERE => {cid => SHARD_IDS, minus_words__is_not_null => 1}]);
$log->out("got " . scalar(@$skip_cids) . " camps currently with minus_words - skip");
$log->out({skip_cids => $skip_cids});

delete @to_check{@$skip_cids};
$log->out("apply changes for " . scalar(keys(%to_check)) . " cids");

for my $cid (nsort keys (%to_check) ) {
    my $mw = $to_check{$cid};
    $log->out({save_minus_words => $mw, cid => $cid});
    save_campaign_minus_words($cid, $mw);
}


$log->out('FINISH');



