#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "1 час",
      comment => 'Запускать только в продакшн. Перед запуском убедиться, что таблица [banach].//home/direct/tmp/icenine/media_disclaimer_DIRECT_74373 существует',
    }
  ],
  approved_by => 'hrustyashko'
}

=cut


use my_inc '..';
use Direct::Modern;

use Yandex::HashUtils;
use Yandex::YT::Table;

use BS::ResyncQueue;
use ScriptHelper;
use Settings;
use Tools ();
use Yandex::Retry qw/relaxed_guard/;

use Yandex::DBTools;
use Yandex::DBShards;

$Yandex::YT::Streaming::DEFAULT_FORMAT = 'json';

$log->out("START");

my $PRIORITY = -100;
my $TABLE = '//home/direct/tmp/icenine/media_disclaimer_DIRECT_74373';

extract_script_params(
    "priority=s" => \$PRIORITY,
    "table=s" => \$TABLE,
);

Tools::force_set_yt_environment('banach');

my $table = Yandex::YT::Table->new($TABLE);
unless ($table->exists()) {
    $log->die("table $TABLE doesn't exists");
}

my $flags_re = 'lottery|forex|forex_broker|mediation';
my $cats_re = '200007526|200027676|200053039|200007354|200000904|200006083';

my @resync;

my $reader = $table->reader();
my @items = ();
while(my $r = $reader->next()) {
    my $item = hash_cut($r, [qw/cid bid pid priority/]);
    $item->{priority} //= $PRIORITY;
    push @items, $item;
    if (@items >= 5_000) {
        _update_resend(\@items);
        @items = ();
    }
}
if (@items) {
    _update_resend(\@items);
}

$log->out("FINISH");

sub _update_resend
{
    my $items = shift;
    foreach_shard bid => $items, by => 'bid', sub {
        my ($shard, $chunk) = @_;
        my $rg = relaxed_guard times => 1;
        do_in_transaction {
            my $bids = get_hash_sql(PPC(shard => $shard), [
                "select b.bid, b.statusArch from banners b
                left join catalogia_banners_rubrics cbr using(bid)",
                where => {
                    'b.bid' => [ map { $_->{bid} } @$chunk ],
                    _OR => {
                        'cbr.categories_bs__rlike' => $cats_re,
                        'b.flags__like' => $flags_re,
                    },
                    'b.flags__not_like' => '%media_disclaimer%',
                },
                'lock in share mode'
            ]);
            $chunk = [ grep { exists $bids->{$_->{bid}} } @$chunk ];
            return unless @$chunk;
            $log->out(['update', $chunk]);
            do_sql(PPC(shard => $shard), [
                "update banners
                set flags = if(length(ifnull(flags,'')) = 0, 'media_disclaimer', concat(flags, ',media_disclaimer'))
                ",
                where => {
                    bid => [ keys %$bids ],
                }
            ]);
            $chunk = [ grep { $bids->{$_->{bid}} eq 'No' } @$chunk ];
        };
        $log->out(['resync', $chunk]);
        BS::ResyncQueue::bs_resync($chunk) if @$chunk;
    };
}
