#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'ppalex',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "несколько минут",
    }
  ]
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards qw/SHARD_IDS/;
use Yandex::Validate qw/is_valid_id/;

use my_inc '..';

use ScriptHelper;
use Settings;
use PrimitivesIds;
use Campaign;

use RBAC2::Extended;

my $login = 'procontext-iledebeaute-old';
my $rbac = eval { RBAC2::Extended->get_singleton(1) } or $log->die("error getting RBAC instance: $@");


$log->out('START');

my $uid = get_uid(login => $login);
my $camp_data = get_all_sql(PPC(uid => $uid), ["select cid, copiedFrom from campaigns", where => {uid => SHARD_IDS}]);
$log->out("Got ". scalar @$camp_data . " campaigs for $login");

my $orig_cid2copied = {};
foreach my $row (@$camp_data) {
    # обрабатываем только скопированные кампании
    if (is_valid_id($row->{copiedFrom})) {
        # если для оригинальной кампании уже есть скопированная - удаляем дубликат
        if (defined $orig_cid2copied->{$row->{copiedFrom}} && is_valid_id($orig_cid2copied->{$row->{copiedFrom}})) {
            $log->out("Deleting campaign $row->{cid} - duplicate of $orig_cid2copied->{$row->{copiedFrom}} copied from $row->{copiedFrom}");
            my $ret = eval {
                del_camp($rbac, $row->{cid}, $uid);
            };
            if ($@ || !$ret) {
                $log->out("Can't delete campaign $row->{cid}: $@");
            }
        } else {
            $orig_cid2copied->{$row->{copiedFrom}} = $row->{cid};
        }
    }
}

$log->out('FINISH');

