#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'zhur',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "1 sec",
      comment => "удаляем криво-созданного старого пользователя без кампаний"
    }
  ]
}

=cut

use Direct::Modern;
use Carp qw/croak/;

use Yandex::DBTools;
use Yandex::DBShards;

use my_inc '..';

use ScriptHelper;
use Settings;

use PrimitivesIds qw/get_cids/;
use User;

$log->out('START');

my $uid = 157707467; # leninmemory2012

if (@{get_cids(uid => $uid)}) {
    croak "There are campaigns for uid=$uid";
}

for my $tbl (keys %User::USER_TABLES) {
    my $rows = get_all_sql(PPC(uid => $uid), ["SELECT * FROM $tbl", WHERE => {uid => $uid}]);
    $log->out("Table: $tbl", $rows);
    if (@$rows) {
        do_delete_from_table(PPC(uid => $uid), $tbl, where => {uid => $uid});
    }
}

delete_shard(uid => $uid);

$log->out('FINISH');

