#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'ppalex',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "5s"
    }
  ]
}

=cut
use my_inc '..';

use Direct::Modern;
use Yandex::DBTools;
use Yandex::DBShards;
use RBAC2::Extended;
use RBACDirect;

use ScriptHelper;
use Settings;

$log->out('START');

my $shard = 4;
my @cids = (
        9271827,
        9437445,
        9835562,
        9891326
);

my $cid2clientid = get_hash_sql( PPC(shard => $shard), [
            "SELECT cid, ClientID FROM campaigns ",
            WHERE => {
                cid => \@cids
            }
        ]);

$log->out("fixing shard for campaigns");
while (my ($cid, $clientid) = each (%$cid2clientid)) {
    $log->out("$cid => $clientid");
    save_shard(cid => $cid, ClientID => $clientid);
}


my $bid2clientid = get_hash_sql( PPC(shard => $shard), [
            "SELECT b.bid, c.ClientID FROM banners b INNER JOIN campaigns c ON ( b.cid = c.cid  ) ",
            WHERE => {
                'c.cid' => \@cids
            }
        ]);

$log->out("fixing shard for banners");
while (my ($bid, $clientid) = each (%$bid2clientid)) {
    $log->out("$bid => $clientid");
    save_shard(bid => $bid, ClientID => $clientid);
}

my $pid2clientid = get_hash_sql( PPC(shard => $shard), [
            "SELECT p.pid, c.ClientID FROM phrases p INNER JOIN campaigns c ON ( p.cid = c.cid )",
            WHERE => {
                'c.cid' => \@cids
            }
        ]);


$log->out("fixing shard for phrases");
while (my ($pid, $clientid) = each (%$pid2clientid)) {
    $log->out("$pid => $clientid");
    save_shard(pid => $pid, ClientID => $clientid);
}


my $vcard2clientid = get_hash_sql(  PPC(shard => $shard), [
            "SELECT v.vcard_id, c.ClientID FROM vcards v INNER JOIN campaigns c ON (v.cid = c.cid)",
            WHERE => {
                'c.cid' => \@cids
            }
        ]);

$log->out("fixing shard for vcards");
while (my ($vcard_id, $clientid) = each (%$vcard2clientid)) {
    $log->out("$vcard_id => $clientid");
    save_shard(vcard_id => $vcard_id, ClientID => $clientid);
}

$log->out("fixing strategy data and platform for cids");
do_update_table(PPC(shard => $shard), 'campaigns', 
                                      { 'LastChange__dont_quote' => 'NOW()', 
                                         strategy_data => '{"name": "default", "version": 1}',
                                         platform => 'both'
                                      }, 
                                      where => {'cid' => \@cids, 'type' => 'text'});

my $rbac = eval { RBAC2::Extended->get_singleton(1) } or $log->die("Error initialising RBAC: $@");


my $cid2permissions = {
    9271827 => { uid => 255250948, manageruid => 223168636 },
    9437445 => { uid => 255250948, manageruid => 223168636 },
    9835562 => { uid => 269213692 },
    9891326 => { uid => 6476606 }
};

$log->out("fixing permissions for cids");
for my $cid (keys %$cid2permissions) {
    my $perms = $cid2permissions->{$cid};
    my $uid = $perms->{uid};
    if (!rbac_user_allow_edit_camp($rbac, $uid, $cid)) {
        my $manageruid = $perms->{manageruid};
        if (defined $manageruid) {
            rbac_save_camp_for_manager($rbac, $manageruid, $uid, $cid);
            $log->out("cid => $cid, manageruid => $manageruid, uid => $uid");
        } else {
            rbac_save_camp($rbac, $uid, $cid);
            $log->out("cid => $cid, uid => $uid");
        }
    }
}


$log->out('FINISH');

