#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'sql',
      db => "ppc:all",
      when => 'before',
      comment => 'dbs-sql + dbs-guard',
      time_estimate => "по паре секунд на шард",
      sql => q{
          ALTER TABLE `adgroups_performance`
          ADD COLUMN `field_to_use_as_name` varchar(40) DEFAULT NULL
      },
    },
    {
      type => 'script',
      when => 'after',
      time_estimate => "30 sec",
    }
  ],
  approved_by => 'liosha'
}

=cut

use Direct::Modern;

use my_inc '..';

use PrimitivesIds qw/get_cid/;
use Direct::AdGroups2::Performance;

use ScriptHelper;
use Settings;


$log->out('START');

my @data = grep {@$_} map {[split /\s{2,}/]} grep {/\d/} <DATA>;
for my $item (@data) {
    my ($order_id, $field) = @$item;
    my $cid = get_cid(OrderID => $order_id);
    if (!$cid) {
        $log->out("!! campaign OrderID=$order_id not found");
        next;
    }

    $log->out(qq/set field="$field" for cid=$cid (OrderID=$order_id)/);

    my $groups = Direct::AdGroups2::Performance->get_by(campaign_id => $cid);
    for my $group (@{$groups->items}) {
        my $pid = $group->id;
        $log->out("updating group pid=$pid");
        $group->old($group->clone);
        $group->field_to_use_as_name($field);
    };

    $log->out("saving to db");
    $groups->update;
}

$log->out('FINISH');


# таблица из https://catmedia.yandex.ru/cgi/ind.pl?cmd=PerfUseAsNameTags&viewoptionsstr=lang_ru

# OrderID   use_as_name Login 

__DATA__
7709994     name    nimalk      
8934267     vendor  d-a-orlova  2018-02-28 13:11:37     
8953441     name    nimalk      
10374648    model   yndx-sivkov-super       
11528737    name    nimalk      
13604420    name    nimalk  2018-03-02 12:43:11     
13758170    name    nimalk      
13812220    vendor  nimalk      
15432408    name    nimalk      
15437816    banner_title    d-a-orlova      
15745638    name    nimalk      
15941037    model   nimalk      
15952887    name    d-a-orlova      
16169645    name    nimalk      
16533314    name    d-a-orlova      
16717976    model   d-a-orlova      
17157904    vendor  nimalk      
17157923    vendor  nimalk      
17157925    vendor  nimalk      
17312321    name    nimalk      
17369417    name    nimalk      
17408222    name    nimalk      
17513065    name    d-a-orlova      
17513103    name    d-a-orlova      
17513207    name    d-a-orlova      
17515949    name    d-a-orlova      
17635067    Property name   d-a-orlova      
17822632    vendor  nimalk      
17822787    vendor  nimalk      
18216033    name    nimalk      
18284210    name    nimalk      
18453957    name    nimalk      
18480522    Property name   sivkovpetr      
18480674    Property name   sivkovpetr      
18480728    Property name   sivkovpetr      
18480828    Property name   sivkovpetr      
18481409    Property name   sivkovpetr      
18481423    Property name   sivkovpetr      
18481482    Property name   sivkovpetr      
18481496    Property name   sivkovpetr      
18481506    Property name   sivkovpetr      
18481557    Property name   sivkovpetr      
18481558    Property name   sivkovpetr      
18481862    Property name   sivkovpetr      
18481863    Property name   sivkovpetr      
18481865    Property name   sivkovpetr      
18683668    Property name   yndx-sivkov-super       
18858544    name    nimalk      
18859078    name    nimalk      
18909571    name    nimalk      
19283577    name    nimalk 

