#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'sql',
      db => "ppc:all",
      when => 'before',
      time_estimate => "1 sec",
      sql => "ALTER TABLE manager_hierarchy ADD COLUMN manager_uid bigint not null after manager_client_id, ADD COLUMN supervisor_uid bigint not null after supervisor_client_id, add index (manager_uid), add index (supervisor_uid)"
    },
    {
      type => 'script',
      when => 'after',
      time_estimate => "30 sec",
      comment => "заполняет новые поля в manager_hierarchy"
    }
  ],
  approved_by => 'zhur'
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;

use Rbac qw/set_manager_supervisor/;

$log->out('START');

for my $row (@{get_all_sql(PPC(shard=>'all'), "SELECT manager_client_id, supervisor_client_id FROM manager_hierarchy")}) {
    set_manager_supervisor($row->{manager_client_id}, $row->{supervisor_client_id});
}

$log->out('FINISH');

