#!/usr/bin/perl

=head1 DESCRIPTION

Ресинк отклонённых креативов для заполнения moderation_comment

=head1 DEPLOY

# approved by liosha
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "10 минут",
  comment => "Можно перезапускать и запускать на ТС",
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;

use Direct::Creatives;
use ShardingTools qw/ppc_shards/;
use Yandex::ListUtils qw/chunks/;


extract_script_params(
    'creative-id=i' => \my @creative_ids,
);


$log->out('START');

for my $shard (ppc_shards()) {
    my $to_sync = get_all_sql(PPC(shard => $shard), [
            "SELECT creative_id, ClientID as client_id
            FROM perf_creatives",
            WHERE => {
                statusModerate => 'No',
                (@creative_ids
                    ? (creative_id => \@creative_ids)
                    : (moderation_comment__is_null => 1)
                ),
            },
        ]);

    for my $chunk (chunks $to_sync, 100) {
        $log->out({ sync_creatives => $chunk });
        Direct::Creatives::sync_creatives($chunk);
    }
}

$log->out('FINISH');

