#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'ppalex',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "несколько секунд",
    }
  ]
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;
use RBACDirect;
use RBACDirectOld qw//;
use Campaign;


my $OPERATOR_UID = 0;

$log->out('START');


my $rbac = RBAC2::Extended->get_singleton(1) or $log->die("Can't connect to RBAC: $@");
my $r = 0;

$log->out("fix senginer camp");
$r = eval { fix_senginer(); return 1; };
if (!$r || $@) {
    $log->out("failed: $@");
} else {
    $log->out("done");
}

$log->out("fix fitnessforma camp");
$r = eval { fix_fitnessforma(); return 1; };
if (!$r || $@) {
    $log->out("failed: $@");
} else {
    $log->out("done");
}


my %wallet_cid2muid = (
    8904909 => 248723610,
    11232611 => 222923897,
    13170502 => 214405767,
    12498392 => 171837683,
);

for my $cid (keys %wallet_cid2muid) {
    $log->out("fix wallet $cid");
    my $muid = $wallet_cid2muid{$cid};
    my $wr = eval {
        return 1 if need_skip($cid, 0, $muid);
        unservice_camp_in_db_and_balance($cid, $muid);
        return 1;
    };
    if (!$wr || $@) {
        $log->out("failed: $@");
    } else {
        $log->out("done");
    }
}

$log->out('FINISH');



sub fix_senginer {
    my $cid = 29237879;
    my $expected_rbac_muid = 156095255;
    my $expected_ppc_muid = 455282928;

    return if need_skip($cid, $expected_rbac_muid, $expected_ppc_muid);

    $log->out("unservice in rbac");
    if (my $err = rbac_move_scamp_to_nscamp($rbac, $cid)) {
        $rbac->Rollback();
        die "rbac_move_scamp_to_nscamp failed: $err";
    }

    unservice_camp_in_db_and_balance($cid, $expected_ppc_muid);
}

sub fix_fitnessforma {
    my $cid = 4686194;
    my $muid = 455282928;

    my $uid = 127358099;

    return if need_skip($cid, $muid, $muid);

    $log->out("bind client $uid to manager $muid in RBAC");
    if (my $err = RBACDirectOld::rbac_bind_manager($rbac, $muid, $uid)) {
        $rbac->Rollback();
        die "error binding client $uid to manager $muid: $err";
    }

    $log->out("unservice in rbac");
    if (my $err = rbac_move_scamp_to_nscamp($rbac, $cid)) {
        $rbac->Rollback();
        die "rbac_move_scamp_to_nscamp failed: $err";
    }

    unservice_camp_in_db_and_balance($cid, $muid);
}


sub need_skip {
    my ($cid, $expected_rbac_muid, $expected_ppc_muid) = @_;

    my $real_ppc_muid = get_one_field_sql(PPC(cid => $cid), 'SELECT ManagerUID FROM campaigns WHERE cid = ?', $cid) // 0;
    my $real_rbac_muid = rbac_is_scampaign($rbac, $cid);

    if (!$real_ppc_muid && !$real_rbac_muid) {
        $log->out("SKIP camp $cid, already unserviced");
        return 1;
    } elsif ($real_rbac_muid != $expected_rbac_muid) {
        $log->out("SKIP camp $cid, unexpected manager in RBAC: $real_rbac_muid");
        return 1;
    } elsif ($real_ppc_muid != $expected_ppc_muid) {
        $log->out("SKIP camp $cid, unexpected manager in PPC: $real_ppc_muid");
        return 1;
    }

    return 0;
}

sub unservice_camp_in_db_and_balance {
    my ($cid, $muid) = @_;

    $log->out("remove manageruid from camp");
    # ManagerUID также был мог быть затерт в rbac_move_scamp_to_nscamp
    do_update_table(PPC(cid => $cid), 'campaigns', { statusBsSynced => 'No', ManagerUID => undef }, where => { cid => $cid });
    $log->out("send camp to balance");
    $log->out(create_campaigns_balance($rbac, $OPERATOR_UID, [$cid]));
    $log->out("notify manager changed");
    campaign_manager_changed($rbac, $muid, $cid, 0);

}
