#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'ppalex',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "9 минут на девтест, в продакшене быстрее",
    }
  ]
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::ListUtils;

use my_inc '..';

use Campaign qw/campaign_manager_changed/;
use RBAC2::Extended;
use RBACDirect;
use ScriptHelper;
use Settings;
use ShardingTools qw/ppc_shards/;

$log->out('START');

my $total_cnt = 0;

my $rbac = RBAC2::Extended->get_singleton(1) or $log->die("Can't connect to RBAC: $@");

for my $shard (ppc_shards()) {
    my $msg_prefix_guard = $log->msg_prefix_guard("[shard $shard]");

    $log->out("fetch serviced wallets");
    my $wallets = get_hash_sql(PPC(shard => $shard), ['SELECT cid, uid FROM campaigns',
                               WHERE => { type => "wallet", statusEmpty => "No", ManagerUID__is_not_null => 1 },
                               ]);

    my @cids;
    $log->out("check campaigns connected to wallet");
    for my $cids_chunk (chunks([keys %$wallets], 500)) {
        my $stat = get_all_sql(PPC(shard => $shard), ['SELECT wallet_cid, COUNT(*) AS cnt, COUNT(ManagerUID) AS serviced FROM campaigns',
                                WHERE => {
                                    wallet_cid => $cids_chunk,
                                    uid => [@{$wallets}{@$cids_chunk}],
                                    statusEmpty => "No",
                                },
                                'GROUP BY wallet_cid',
                                ]);
        for my $row (@$stat) {
            if ($row->{serviced} == 0) {
                push @cids, $row->{wallet_cid};
            } else {
                $log->out("SKIP wallet $row->{wallet_cid} has $row->{serviced} serviced campaigns, $row->{cnt} total connected campaigns");
            }
        }
    }
    $total_cnt += @cids;

    $log->out("going to unservice " . (scalar(@cids)) . ' campaigns');

    # творческий copy-paste из one-shot/unservice_wallet.pl
    my $campaigns = get_hashes_hash_sql(PPC(shard => $shard), ["SELECT cid, type, ManagerUID FROM campaigns", where => {cid => \@cids}]);
    for my $cid (@cids) {
        if (!$campaigns->{$cid} || $campaigns->{$cid}->{type} ne 'wallet') {
            $log->out(sprintf "SKIP campaign %d isn't a wallet", $cid);
            next;
        }
        unless (rbac_is_scampaign($rbac, $cid)) {
            $log->out(sprintf "SKIP campaign %d isn't servicing", $cid);
            next;
        }
        eval {
            my $t = Campaign::unservice_orders_in_balance([$cid]);
        };
        if ($@) {
            $log->out("ERROR unservice wallet in balance error " . $@);
            next;
        }

        my $rbac_error = rbac_move_scamp_to_nscamp($rbac, $cid);
        if ($rbac_error) {
            $log->out("ERROR rbac_move_scamp_to_nscamp(\$rbac, $cid) == $rbac_error");
            next;
        }
        $log->out(sprintf "campaign %d successfully unserviced", $cid);
        campaign_manager_changed($rbac, $campaigns->{$cid}->{ManagerUID}, $cid, 0);
        do_sql(PPC(cid => $cid), "UPDATE campaigns SET statusBsSynced = 'No' WHERE cid = ?", $cid); 
    }
}

$log->out("total unserviced camps $total_cnt");

$log->out('FINISH');

