#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'hrustyashko',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "несколько часов",
      comment => "Убираем флаг media_disclaimer если есть динамический дисклеймер и переотправляем в БК"
    }
  ]
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;

use my_inc '..';

use ScriptHelper;
use Settings;
use ShardingTools qw/ppc_shards/;
use BS::ResyncQueue;

my $CID;
extract_script_params("cid=s" => \$CID);

$log->out('START');

my $chunk = 5_000_000;

my @shards = ppc_shards();

if ($CID) {
    @shards = ( get_shard(cid => $CID) );
}

for my $shard (@shards) {
    my $mpg = $log->msg_prefix_guard("shard_$shard");
    my $update = {};
    my $resend = [];
    my ($min, $max) = get_one_line_array_sql(PPC(shard => $shard), [ "select min(bid), max(bid) from banners", ( $CID ? (where => { cid => $CID }) : () ) ]);
    while ($min < $max) {
        $log->out("$min / $max");
        my $rows = get_all_sql(PPC(shard => $shard), [
            "select cid, b.bid, 42 as priority, flags, image_id
            from banners b
            JOIN banners_additions bad ON (bad.bid=b.bid AND bad.additions_type='disclaimer')
            JOIN additions_item_disclaimers aid ON (aid.additions_item_id = bad.additions_item_id)
            LEFT JOIN banner_images bim on bim.bid = b.bid",
            where => {
                'b.bid__between' => [$min, $min + $chunk-1],
                'b.flags__like' => '%media_disclaimer%',
                'disclaimer_text__is_not_null' => 1,
                'disclaimer_text__ne' => '',
                ( $CID ? ( 'b.cid' => $CID ) : () ),
            },
        ]);
        if (!@$rows) {
            $min += $chunk;
            next;
        }
        for my $row (@$rows) {
            $update->{$row->{bid}}{flags} = join ',', grep { $_ ne 'media_disclaimer' } split /,/, $row->{flags};
            if ($row->{image_id}) {
                push @$resend, $row;
            }
        }
        if (keys %$update >= 100) {
            $log->out($update);
            do_mass_update_sql(PPC(shard => $shard), 'banners', bid => $update);
            $update = {};
        }
        if (@$resend >= 1000) {
            my $resend_cnt = BS::ResyncQueue::bs_resync($resend);
            $log->out('resent ' . $resend_cnt . ' banners');
            $resend = [];
        }
        $min += $chunk;
    }
    if (keys %$update) {
        $log->out($update);
        do_mass_update_sql(PPC(shard => $shard), 'banners', bid => $update);
        $update = {};
    }
    if (@$resend) {
        my $resend_cnt = BS::ResyncQueue::bs_resync($resend);
        $log->out('resent ' . $resend_cnt . ' banners');
        $resend = [];
    }
}

$log->out('FINISH');

