#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'ppalex',
  tasks => [
    {
      type => 'script',
      when => 'instructions',
      instructions => "нужно будет запустить по отмашке pashkus",
      time_estimate => "8 минут на шард",
      comment => "можно перезапускать"
    }
  ]
}

=cut
use my_inc '..';

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;
use ShardingTools qw/ppc_shards/;

use ScriptHelper;
use Settings;

my $ONLY_SHARDS = undef;
my $CHUNK_SIZE = 100000;


$log->out('START');

extract_script_params(
    'only-shards:s' => \$ONLY_SHARDS,
    'chunk-size:i'  => \$CHUNK_SIZE,
);

die "No valid chunk-size specified" if $CHUNK_SIZE < 1;

$log->out('START');

my @shards = defined $ONLY_SHARDS ? grep { /^\d+$/ } (split /,/, $ONLY_SHARDS) : ppc_shards();
die "No valid shards specified" unless @shards;
$log->out("Running on shards: ". join ',', @shards);

foreach_shard(shard => \@shards, sub {
        my ($shard) = @_;
        $log->msg_prefix("[shard:$shard]");
        my ($ret_id, $max_ret_id) = get_one_line_array_sql(PPC(shard => $shard), "select min(ret_id), max(ret_id) from bids_retargeting");
        $ret_id //= 0;
        $max_ret_id //= 0;
        $log->out("got min & max ret_id: $ret_id, $max_ret_id");

        while ($ret_id < $max_ret_id) {
            $log->out("updating ret_ids: $ret_id + $CHUNK_SIZE");
            my $count = do_sql(PPC(shard => $shard),
                ["update bids_retargeting br join phrases p using (pid) set br.cid = p.cid",
                    WHERE => {
                        "br.ret_id__between" => [ $ret_id, $ret_id + $CHUNK_SIZE ],
                        "br.cid" => 0
                    }]);
            $log->out("updated $count ret_ids");
            $ret_id += $CHUNK_SIZE + 1;
        }
    });

$log->out('FINISH');
