#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "30 минут",
      comment => "пытается восстановить clients.create_date как min(users.createtime, campaigns.create_time)"
    }
  ],
  approved_by => 'zhur'
}

=cut

use Direct::Modern;

use JSON;
use List::Util qw/minstr/;

use Yandex::DBTools;
use Yandex::ListUtils;
use Yandex::Retry;

use my_inc '..';

use ScriptHelper 'Yandex::Log' => 'messages';
use Settings;
use ShardingTools;

my $SELECT_CHUNK_SIZE = 10_000;
my $UPDATE_CHUNK_SIZE = 200;

$log->out('START');

for my $shard (ppc_shards()) {
    my $from = 0;
    while(1) {
        $log->out("SHARD=$shard, FROM=$from");
        my $rows = get_all_sql(PPC(shard => $shard), "
                    SELECT cl.ClientID, cl.create_date as clients_date
                         , min(if(from_unixtime(u.createtime)>='2003-01-01', from_unixtime(u.createtime), now())) as users_date
                         , min(if(co.create_time>='2003-01-01', co.create_time, now())) as camps_date
                      FROM clients cl 
                           JOIN users u USING (ClientID)
                           LEFT JOIN campaigns c using(ClientID)
                           LEFT JOIN camp_options co using(cid)
                     WHERE cl.ClientID > ?
                     GROUP BY cl.ClientID 
                           HAVING clients_date > users_date 
                               OR camps_date is not null and clients_date > camps_date
                     ORDER BY cl.ClientID
                     LIMIT ?", $from, $SELECT_CHUNK_SIZE);
        for my $chunk (chunks $rows, $UPDATE_CHUNK_SIZE) {
            my %data;
            for my $row (@$chunk) {
                $row->{new_clients_date} = minstr(grep {$_ gt '2003-'} grep {defined} ($row->{clients_date}, $row->{users_date}, $row->{camps_date}));
                $log->out("row: ".to_json($row));
            }
            relaxed times => 1, sub {
                do_mass_update_sql(PPC(shard => $shard), "clients", 'ClientID',
                               {map {$_->{ClientID} => {create_date => $_->{new_clients_date}}} @$chunk}
                    );
            };
        }
        last if @$rows != $SELECT_CHUNK_SIZE;
        $from = $rows->[-1]->{ClientID};
    }
}

$log->out('FINISH');

