#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'hrustyashko',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "2 минуты",
      comment => "По логам запросов восстанавливаем регистр фраз который указал пользователь

              для запуска скопировать файл ppcdev2:/home/hrustyashko/requestsWithUpperCase.json

              ./deploy/20180228_fix_phrases_lower_case.pl requestsWithUpperCase.json"
    }
  ]
}

=cut

use my_inc '..';
use open ':std' => ':utf8';

use Direct::Modern;
use File::Slurp qw/read_file/;
use JSON;
use ScriptHelper;
use Settings;
use Yandex::DBTools;
use Yandex::DBShards;
use BS::ResyncQueue qw/bs_resync/;

my $DRY_RUN = 0;

die 'unknown file name' unless -e $ARGV[0];

$log->out('START');
$log->out('read file ' . $ARGV[0]);

my $row = 0;
my @lines = read_file($ARGV[0], binmode => ':utf8'); 

my %upper_case_keywords;
for my $line (@lines) {

    $row++;

    $line =~ s/,$//;

    my $request = eval {
        from_json($line);
    };
    if ($@ || ref $request ne 'HASH') {
        $log->out("invalid json in row #" . $row);         
        next;
    }
    my $adgroups = $request->{keywords};
    for my $pid (grep { /^[0-9]+$/ } keys %$adgroups) {
        while (my ($id, $phrase) = each %{$adgroups->{$pid}->{edited} || {}}) {
            next unless $phrase->{phrase};
            if ($phrase->{phrase} ne lc($phrase->{phrase})) {
                $upper_case_keywords{$pid} = [] unless exists $upper_case_keywords{$pid};
                push @{$upper_case_keywords{$pid}}, [$id, $phrase->{phrase}];
            }
        }
    }
}

$log->out(sprintf "read %d lines from file", @lines + 0);


my $updated = 0;
foreach_shard pid => [keys %upper_case_keywords], sub {
    my ($shard, $pids) = @_;
    my %right_keywords;
    for my $pid (@$pids) {
        $right_keywords{$_->[0]} = $_->[1] for @{$upper_case_keywords{$pid}};
    }
    my @resync;
    my (%bids, %bids_old);
    my $current_keywords = get_all_sql(PPC(shard => $shard), ["SELECT id, cid, pid, phrase FROM bids", WHERE => {id => [keys %right_keywords]}]);
    for my $keyword (@$current_keywords) {
        if (lc($right_keywords{$keyword->{id}}) eq lc($keyword->{phrase})) {
            $updated++;
            push @resync, { cid => $keyword->{cid}, pid => $keyword->{pid} };
            $bids{$keyword->{id}}{phrase} = $right_keywords{$keyword->{id}};
            $bids_old{$keyword->{id}} = $keyword->{phrase};
            $log->out(sprintf "update keyword %d to %s", $keyword->{id}, $right_keywords{$keyword->{id}});
        }
    }

    if (!$DRY_RUN) {
        do_mass_update_sql(PPC(shard => $shard), 'bids', id => \%bids, 
                           where => { phrase__dont_quote => sql_case( id => \%bids_old, default__dont_quote => sql_quote_identifier('phrase')) });
        bs_resync(\@resync);
    }
};


$log->out("total updated phrases - " . $updated);
$log->out("FINISH");
