#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'ppalex',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "несколько секунд",
    }, {
        type => 'sql',
        when => 'after',
        db => 'ppc:1',
        sql => 'DELETE FROM bs_export_queue WHERE cid IN (9285053, 9063364, 8969011)',
        time_estimate => 'меньше секунды'
    }
  ]
}

=cut

use Direct::Modern;

use Yandex::DBShards;

use my_inc '..';

use ScriptHelper;
use Settings;

# ClientID из метабазы => ClientID из campaigns
my %clients2fix = (
    4398439 => 313845,  # cid 8969011
    4475290 => 2307395, # cid 9063364
    4683960 => 2548214, # cid 9285053
);

my @keys_to_fix = grep { ($Yandex::DBShards::SHARD_KEYS{$_}->{chain_key} // '') eq 'ClientID' } keys %Yandex::DBShards::SHARD_KEYS;

$log->out('START');

$log->out("fetch backup data");
my %backup;
for my $key (@keys_to_fix) {
    $backup{$key} = Yandex::DBShards::get_sharded_vals_multi(ClientID => [%clients2fix], $key);
}
$log->out({backup => \%backup});

for my $ClientID (keys %clients2fix) {
    my $correctId = $clients2fix{$ClientID};
    my $shard = get_shard(ClientID => $correctId);
    $log->out("change shard for $ClientID to $shard");
    save_shard(ClientID => $ClientID, shard => $shard);
    $log->out("fix chain: $ClientID -> $correctId");
    update_shard_chain("ClientID", $ClientID => $correctId);
}

$log->out("fetch result data");
my %result;
for my $key (@keys_to_fix) {
    $result{$key} = Yandex::DBShards::get_sharded_vals_multi(ClientID => [%clients2fix], $key);
}
$log->out({result => \%result});

$log->out('FINISH');
