#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'hrustyashko',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "5 секунд",
    }]
}

=cut

use Direct::Modern;

use Yandex::DBShards;
use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;
use ShardingTools;
use Yandex::ListUtils qw/chunks/;

$log->out('START');
foreach_shard shard => [ppc_shards()], sub {
    my ($shard) = @_;

    my $shard_bids = get_one_column_sql(PPC(shard => $shard),
      "select bid from banners join banners_performance using(bid) join perf_creatives using(creative_id) where layout_id = 44 and creative_type = 'performance' and statusArch = 'Yes' AND statusShow = 'Yes' ORDER BY bid");

    $log->out(sprintf "found %d banners", @$shard_bids + 0);

    foreach my $bids (chunks($shard_bids, 100)) {
        $log->out("stop bids " . join ",", @$bids);
        do_update_table(PPC(shard => $shard), 'banners b join phrases p using(pid)', {
            'b.lastChange__dont_quote' => 'b.lastChange',
            'b.statusShow' => 'No',
            'b.statusBsSynced' => 'No',
            'p.statusBsSynced' => 'No',
            'p.lastChange__dont_quote' => 'p.lastChange',
         }, where => {
             'b.bid' => $bids,
             'b.statusArch' => 'Yes',
             'b.statusShow' => 'Yes'
        });
    } 
};
$log->out('FINISH');

