#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'ppalex',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "полчаса",
    }
  ]
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use Moderate::Mail qw/get_cid_clientid_where_condition/;
use ScriptHelper;
use Settings;
use ShardingTools;
use Yandex::ListUtils qw/chunks/;
use List::MoreUtils qw/uniq/;

my $DELETE_CHUNK = 500;

$log->out('START');
for my $shard (ppc_shards()) {
    $log->out("Processing shard $shard");
    my $mmc_delete = get_all_sql(PPC(shard => $shard), "SELECT ClientID, cid, last_update_time, status FROM mod_mail_candidates WHERE ClientID = 0");
    $log->out({ msg => "Deleting from mod_mail_candidates", ids => $mmc_delete });
    for my $chunk (chunks($mmc_delete, $DELETE_CHUNK)) {
        do_delete_from_table(PPC(shard => $shard), 'mod_mail_candidates', where => get_cid_clientid_where_condition($chunk));
    }

    my $mr_delete = get_all_sql(PPC(shard => $shard), "SELECT DISTINCT rid, id, type, ClientID, cid, statusSending, statusModerate, statusPostModerate, timeCreated, reason FROM mod_reasons WHERE ClientID = 0 AND statusSending != 'Yes'");
    $log->out({ msg => "Deleting from mod_reasons", ids => $mr_delete });
    my @cids_to_delete = uniq map {$_->{cid}} @$mr_delete;
    for my $chunk (chunks(\@cids_to_delete, $DELETE_CHUNK)) {
        do_delete_from_table(PPC(shard => $shard), 'mod_reasons', where => {cid => $chunk, ClientID => 0});
    }

    my $mmc_insert = get_all_sql(PPC(shard => $shard), "SELECT DISTINCT mr.ClientID, mr.cid FROM mod_reasons mr LEFT JOIN mod_mail_candidates mmc ON mmc.cid = mr.cid AND mmc.ClientID = mr.ClientID WHERE mr.statusSending != 'Yes' AND mmc.cid IS NULL");
    $log->out({ msg => "Inserting to mod_mail_candidates", ids => $mmc_insert });
    do_mass_insert_sql(
        PPC(shard => $shard),
        q/insert ignore into mod_mail_candidates (ClientID, cid) values %s/,
        [ map {[ $_->{ClientID}, $_->{cid} ]} @$mmc_insert ],
        { dont_quote => 1 }
    );

    $log->out("Finished shard $shard");
}
$log->out('FINISH');

