#!/usr/bin/perl

=head1 DEPLOY
# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'instructions',
      instructions => "применить в любое время, можно применять повторно если что,
        на ТС запустит тестировщик в рамках тестирования,
        до выкладки кода запускать нужды нет",
      time_estimate => "менее секунды на каждом шарде",
      comment => "нужно применить на ТС и проде, можно запускать с --dry-run для проверки данных"
    }
  ],
  approved_by => 'hmepas'
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::ListUtils;

use my_inc '..';

use ShardingTools qw/ppc_shards/;
use ScriptHelper;
use Settings;

my $CHUNK_SIZE = 1_000;

=head1 DESCRIPTION
    Смысл в том, чтобы найти записи, в которых createtime был проставлен в микросекунах
    (нужно в секундах). Для этого берём значение, которое слишком велико
    для даты создания пользователя в секундах. Например 2e9 – соответствует 2033-му году.
=cut
my $TOO_MANY_SECONDS = 2e9;

my $DRY_RUN;
extract_script_params('dry-run|n' => \$DRY_RUN);

$log->out('START');
if ($DRY_RUN) {
    $log->out("dry-run mode");
}
for my $shard (ppc_shards()) {
    update_in_shard($shard);
}
$log->out('FINISH');

sub update_in_shard {
    my ($shard) = @_;
    $log->out("shard $shard");
    my $users = get_all_sql(PPC(shard => $shard), [
        "SELECT uid, createtime FROM users",
        WHERE => {'createtime__gt' => $TOO_MANY_SECONDS},
        "ORDER BY uid"
    ]);
    $log->out("Rows count: " . scalar(@$users));
    for my $chunk ( chunks( \@$users, $CHUNK_SIZE ) ) {
        update_chunk_in_shard($shard, $chunk);
    }
}

sub update_chunk_in_shard {
    my ($shard, $chunk) = @_;

    $log->out(join(",\n" => map {"uid=$_->{uid} createtime=$_->{createtime}"} @$chunk));
    unless ($DRY_RUN) {
        my $uids = [map {$_->{uid}} @$chunk];
        do_update_table(PPC(shard => $shard), 'users',
            {createtime__dont_quote => 'createtime / 1000'},
            where => {
                'createtime__gt' => $TOO_MANY_SECONDS,
                'uid' => $uids,
            }
        );
    }
}

