#!/usr/bin/env perl

=head1 DEPLOY

# .migr
{
    tasks => [
        {
            type => 'script',
            when => 'after',
            time_estimate => "пара минут",
            comment => "можно перезапускать. На ТС запускать не нужно"
        }
    ],
    approved_by => 'ppalex'
}

=cut

=pod

        Код, готовящий данные, приложен в тикете https://st.yandex-team.ru/DIRECT-79426 комментарием.

=cut

use Direct::Modern;
use Path::Tiny qw(path);
use JSON;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;

$log->out('START');

my $json_string = path(my_inc::path('20180525_delete_forgotten_multipliers.data'))->slurp;
my $data = decode_json($json_string);

for my $type(qw/demo_mult.data pct_mult.data ret_mult.data/) {
    for my $shard (sort {$a <=> $b} keys %{$data->{$type}}) {
        my $guard = $log->msg_prefix_guard("[shard $shard]");
        while (my @collection = splice @{$data->{$type}->{$shard}}, 0, 1000) {
            dump_and_drop($shard, $type, \@collection);
        }
    }
}

sub dump_and_drop {
    my ($shard, $type, $ids) = @_;
    return unless @$ids;
    $log->out('Going to delete data from hierarchical_multipliers');
    my $data = get_all_sql(PPC(shard => $shard), ["select * from hierarchical_multipliers", where => {hierarchical_multiplier_id => $ids}]);
    $log->out({table => "hierarchical_multipliers", data => $data});
    my $rows_deleted = do_delete_from_table(PPC(shard => $shard), 'hierarchical_multipliers', where => {hierarchical_multiplier_id => $ids});
    $log->out('deleted ' . (0 + $rows_deleted) . ' rows from hierarchical_multipliers');
    if ($type eq 'demo_mult.data') {
        $log->out('Going to delete additional data from demography_multiplier_values');
        $data = get_all_sql(PPC(shard => $shard), ["select * from demography_multiplier_values", where => {hierarchical_multiplier_id => $ids}]);
        $log->out({table => "demography_multiplier_values", data => $data});
        my $rows_deleted = do_delete_from_table(PPC(shard => $shard), 'demography_multiplier_values', where => {hierarchical_multiplier_id => $ids});
        $log->out('deleted ' . (0 + $rows_deleted) . ' rows demography_multiplier_values');
    } elsif ($type eq 'ret_mult.data') {
        $log->out('Going to delete additional data from retargeting_multiplier_values');
        $data = get_all_sql(PPC(shard => $shard), ["select * from retargeting_multiplier_values", where => {hierarchical_multiplier_id => $ids}]);
        $log->out({table => "retargeting_multiplier_values", data => $data});
        my $rows_deleted = do_delete_from_table(PPC(shard => $shard), 'retargeting_multiplier_values', where => {hierarchical_multiplier_id => $ids});
        $log->out('deleted ' . (0 + $rows_deleted) . ' rows from retargeting_multiplier_values');
    }
}

$log->out('FINISH');
