#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'ppalex',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "1 месяц (примерная оценка на devtest, в продакшене ожидаем более быстрое выполнение)",
      comment => "Миграцию можно перезапускать, прогресс сохраняется в property (при перезапуске начинаем с того места, где закончили)
                  На ТС запускать с параметром --cid 283439 --shard 5"
    }
  ]
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::Retry qw/relaxed_guard/;
use Yandex::ListUtils qw/chunks/;

use my_inc '..';

use ScriptHelper;
use ShardingTools;
use Settings;

my $STEP = 500;

extract_script_params(
    'cid=i' => \my $only_cid,
    'shard=i' => \my $only_shard,
    'from-beginning' => \my $from_beg,
    'step=i' => \$STEP
);

$log->out('START');

my $MAX_CID_SUFFIX = "_max_cid";
my $LEFT_BOUND_SUFFIX = "_left_bound";

foreach_shard_parallel_verbose($log, sub {
    my $shard = shift;

    if (defined($only_shard) && $only_shard != $shard) {
        return;
    }

    my $left_bound_prop;
    my $left_bound, my $right_bound;
    my $step_num, my $step_cnt;
    my $max_cid;

    if ($only_cid){

        $left_bound = $only_cid;
        $max_cid = $only_cid;
        $step_num = 1;
        $step_cnt = 1;

    } else {

        my $max_cid_prop = Property->new(get_script_name(shardid => $shard).$MAX_CID_SUFFIX);
        $max_cid = $max_cid_prop->get();
        if (!defined($max_cid)) {
            $max_cid = get_one_field_sql(PPC(shard=>$shard), "SELECT max(cid) FROM campaigns");
            $max_cid_prop->set($max_cid);
        }

        my $min_cid = get_one_field_sql(PPC(shard=>$shard), "SELECT min(cid) FROM campaigns");

        $left_bound_prop = Property->new(get_script_name(shardid => $shard).$LEFT_BOUND_SUFFIX);
        $left_bound = $left_bound_prop->get();

        if ($from_beg) {
            $left_bound = $min_cid;
            $left_bound_prop->set($min_cid);
        }

        if (!defined($left_bound)) {
            $left_bound = $min_cid;
        }

        $step_num = POSIX::floor(($left_bound - $min_cid) / $STEP) + 1;
        $step_cnt = POSIX::floor(($max_cid - $min_cid) / $STEP);
    }

    my $total_cnt = 0;

    while ($left_bound <= $max_cid) {

        $log->msg_prefix("[shard=$shard, step $step_num / $step_cnt]");

        $right_bound = $left_bound + $STEP > $max_cid ? $max_cid : $left_bound + $STEP;

        if ($only_cid) {
            $right_bound = $only_cid;
        }

        $log->out("bounds $left_bound, $right_bound");

        my $invalid_data = get_all_sql(PPC(shard => $shard), "
            SELECT bi_hp.id, bi_hp.cid, bi_hp.param1, bi_hp.param2
            FROM bids_href_params bi_hp
                LEFT JOIN bids ON bids.id = bi_hp.id
                LEFT JOIN bids_arc ba ON ba.cid = bi_hp.cid AND ba.id = bi_hp.id
            WHERE bi_hp.cid BETWEEN ? AND ?
                AND bids.id IS NULL
                AND ba.id IS NULL",
            $left_bound, $right_bound);

        if (@$invalid_data) {
            $log->out("rows to delete:", $invalid_data);

            foreach my $chunk (chunks($invalid_data, 1000)) {
                my $g = relaxed_guard(times => 1);
                my (@ids, %cids);
                for my $row (@$chunk) {
                    push @ids, $row->{id};
                    $cids{$row->{cid}} = undef;
                }
                $log->out("to delete:", "ids:", \@ids, "cids:", [keys %cids]);
                my $cnt = do_delete_from_table(PPC(shard => $shard), 'bids_href_params', where => {id => \@ids, cid => [keys %cids]});
                $log->out("deleted $cnt rows");
                $total_cnt += $cnt;
            }
        } else {
            $log->out("no data selected");
        }

        $left_bound += $STEP + 1;
        $step_num += 1;

        if (!$only_cid) {
            $left_bound_prop->set($left_bound); # последний шаг сетит проперти больше, чем максимальный cid, для того чтобы при перезапуске не запускался цикл
        }

        $log->out("step done");
    }

    $log->msg_prefix("[shard=$shard]");
    $log->out("DONE, total deleted count: $total_cnt");
});

# удаляем property (при заданном cid мы не трогали property)
if (!$only_cid) {

    foreach my $shard (ppc_shards()) {

        if (defined($only_shard) && $only_shard != $shard) {
            next;
        }

        my $left_bound_prop_name = get_script_name(shardid => $shard).$LEFT_BOUND_SUFFIX;
        my $left_bound_prop = Property->new($left_bound_prop_name);
        $log->out("property $left_bound_prop_name value:", $left_bound_prop->get());
        $left_bound_prop->delete();
        $log->out("property $left_bound_prop_name deleted");

        my $max_cid_prop_name = get_script_name(shardid => $shard).$MAX_CID_SUFFIX;
        my $max_cid_prop = Property->new($max_cid_prop_name);
        $log->out("property $max_cid_prop_name value:", $max_cid_prop->get());
        $max_cid_prop->delete();
        $log->out("property $max_cid_prop_name deleted");
    }
}

$log->out('FINISH');
