#!/usr/bin/env perl

=head1 DEPLOY

# .migr
{
    approved_by => 'ppalex',
    tasks => [
        {
            type => 'script',
            when => 'after',
            time_estimate => "20s",
            comment => "можно перезапускать. На ТС запускать не нужно"
        }
    ]
}

=cut

=pod

        Данные собирались и склеивались вручную из таких запросов:
        USE banach;
        SELECT DISTINCT p.pid FROM [home/direct/db-archive/2018-05-29/bids] AS b
        JOIN [home/direct/db-archive/2018-05-29/phrases] AS p ON b.pid = p.pid
        JOIN [home/direct/db-archive/2018-05-29/campaigns] AS c ON p.cid = c.cid
        WHERE c.currency = 'TRY'
            AND p.adgroup_type = 'cpm_banner'
            AND ((CAST(b.price AS Double) < 0.3 AND CAST(b.price AS Double) > 0)
        OR (CAST(b.price_context AS Double) < 0.3 AND CAST(b.price_context AS Double) > 0));

        Адекватность потом проверялась в скрипте:
        for my $currency (keys %$data) {
            say $currency;
            my $pids = $data->{$currency};
            say @{get_one_column_sql(PPC(pid => $pids), ["select currency from campaigns c join phrases p on c.cid = p.cid", where => {pid => SHARD_IDS}])};
            local $, = "\n";
            say @{get_one_column_sql(PPC(pid => $pids), ["select adgroup_type from phrases", where => {pid => SHARD_IDS}])};
        }

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;

use my_inc '..';

use Currencies;
use ScriptHelper;
use Settings;

$log->out('START');

# pid, которые нужно обновить, и их валюты.
my $data = {
    "BYN" => [3232235843,3232262908,3232266929,3232288857,3232288858,3256158158,3278312915,3278679065,3281866435,3291674636,3297231016,3300231529,3311852183,3321475457],
    "KZT" => [3290069711,3317333945,3318309978,3320524627],
    "RUB" => [3064758043,3080953668,3081631300,3153097401,3226029783,3226218960,3226391478,3226397905,3226569080,3226584605,3226867405,3227467927,3228177266,3228411916,3228460856,3229471408,3230350744,
    3230577890,3230622428,3230658263,3230674451,3230783968,3230823015,3231103517,3231404193,3231447327,3231561273,3231591594,3231593201,3231595075,3231596783,3231697604,3231929156,3232271854,3232297977,
    3232487031,3232552718,3232892735,3233401001,3235370328,3235656811,3235678920,3235714357,3235753769,3236457188,3236474452,3236475663,3237077334,3237235603,3237235712,3237235716,3237235852,3237235853,
    3237235854,3237236292,3237236295,3237996266,3238111564,3238484758,3238485091,3238485497,3238487183,3238787337,3239797753,3240989386,3241291250,3241467485,3241479300,3241494184,3242678210,3244081891,
    3244645433,3244726872,3245804518,3245804551,3245892661,3245949410,3245964239,3245982832,3246247574,3246453804,3246711791,3247300843,3247491915,3247492619,3248000552,3248869754,3248892313,3249088175,
    3249093855,3250046831,3250082508,3250084495,3250085145,3250605333,3250618910,3250729077,3251654520,3251658077,3251921164,3251969338,3252444583,3252544501,3253389499,3254537091,3256101322,3256402175,
    3256437940,3256447813,3256453968,3256510691,3256710657,3256715222,3256791042,3256796497,3256864317,3256915178,3256955539,3256962356,3256983825,3257227327,3257274868,3258153851,3258168734,3258170807,
    3258179015,3258185832,3258187209,3258259972,3258327223,3258362084,3258681484,3258699081,3259138810,3259712855,3260571329,3260717229,3261356263,3262219718,3262327307,3262872576,3264347972,3264527341,
    3265207930,3265264892,3265466027,3265472854,3265476746,3265484004,3266119895,3266155423,3266210061,3266218365,3266228186,3266241101,3266260875,3266271891,3266279321,3266303108,3266934502,3267319322,
    3267524562,3267869420,3268245797,3268842666,3268970326,3269392393,3270021105,3271725986,3271759428,3271975016,3272058452,3272205668,3272205669,3272205670,3272599691,3273746040,3276617914,3277050831,
    3277082193,3277084267,3277085637,3277129122,3277269777,3278275502,3278288838,3278297129,3278304300,3278733603,3278766665,3279090926,3280781289,3280785266,3281517613,3282887281,3283348030,3283349573,
    3283643812,3283643813,3283643814,3283674373,3284080103,3285478308,3285637270,3286339751,3286428361,3286450023,3286513842,3289123060,3289528200,3289612365,3289612368,3289612369,3289612370,3289896279,
    3289898907,3290906716,3291625934,3291942642,3292197930,3292903559,3292938644,3293009536,3293893851,3294012258,3294363820,3294543005,3295267713,3295414560,3295691270,3296914069,3297127786,3297137557,
    3298546371,3298563285,3298567624,3298576197,3299233098,3299846914,3299854954,3299988521,3300078702,3300078703,3300078704,3300078705,3300641404,3300920572,3300975377,3300980369,3301266628,3302216226,
    3302273364,3302303718,3302746683,3302867258,3303117941,3303684958,3303849249,3303940248,3303942199,3303945697,3303945957,3303950230,3304010225,3304017332,3304019419,3304926699,3304939085,3304941851,
    3304959990,3305072631,3305386514,3305980612,3305983604,3306799371,3307392014,3308048602,3308056009,3308056448,3308056449,3308058250,3308066778,3308067865,3308069083,3308070171,3308070891,3308071442,
    3308072432,3308077386,3308077395,3308078838,3308081231,3308082786,3308086392,3308086502,3308086731,3308086779,3308086904,3308086940,3308088209,3308088323,3308089655,3308089852,3308089892,3308090451,
    3309139164,3309879895,3309992562,3310152405,3310319104,3310322435,3310329963,3310646119,3311227690,3311260457,3312200458,3312205631,3312221106,3312564803,3312681256,3312751445,3312769337,3312811349,
    3312854563,3312885205,3312898117,3313056480,3313304039,3313497036,3313701733,3313754244,3313790839,3313803991,3313832285,3313865815,3313936588,3314300621,3314322543,3314357365,3314480970,3314487745,
    3314491419,3314497011,3314502260,3314646320,3315384925,3315567848,3315616997,3315643394,3315909228,3316526841,3316531647,3316533009,3316533315,3316537972,3316589560,3317302870,3317308992,3317329071,
    3317331453,3317879871,3319015182,3319015184,3319135024,3319160527,3319163471,3319166119,3319171198,3319286616,3319355205,3319355206,3319355207,3319355208,3319545110,3319582585,3320038662,3320233364,
    3320250456,3320257945,3320288447,3320833197,3320984721,3321122697,3321142063,3321179166,3321434822,3322302278,3322357750,3322434044,3323724409,3323776680,3323922357,3324071106,3324324218,3324324220,
    3324324221,3324324222,3324374844,3324851140,3325151012,3325309448,3325314264,3325321229,3325325514,3325334309,3326030087,3326219024,3326316274,3327074453,3327075760,3327077273,3327077700,3327078127,
    3327079467,3327080698,3327081563,3327081898,3327082272,3327082419,3327082566,3327251689,3327968136,3327985651,3328098495,3328525263,3329278183,3329562637,3329648727,3330551441,3330710762,3331377472,
    3331555985,3331978726,3331991286,3333125658,3333130644,3334091083,3335100118,3335737431,3336177990,3336259132,3336343343,3337322677],
    "TRY" => [3233944844],
    "USD" => [3238458807,3304709480,3315630869]
};

for my $currency (keys %$data) {
    my $min_price = get_currency_constant($currency, 'MIN_CPM_PRICE');
    my $value_string = "IF(price = 0, price, GREATEST(price, $min_price))";
    my $value_string_context = "IF(price_context = 0, price_context, GREATEST(price_context, $min_price))";
    my $pids = $data->{$currency};
    $log->out("Going to update values for $currency with a minimum of $min_price");
    for my $table (qw/bids bids_base/) {
        my $id = $table eq 'bids' ? 'id' : 'bid_id';
        my $log_data = get_all_sql(PPC(pid => $pids), ["select pid, $id, price, price_context from $table", where => {pid => SHARD_IDS}]);
        $log->out({data => $log_data, table => $table});
        my $bids_count = do_update_table(PPC(pid => $pids), $table, {price__dont_quote => $value_string, price_context__dont_quote => $value_string_context}, where => {pid => SHARD_IDS});
        $log->out("updated " . (0 + $bids_count) . " rows");
    }
}

$log->out('FINISH');
