#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'sql',
      db => 'ppc:all',
      when => 'before',
      time_estimate => '10 sec',
      sql => 'CREATE TABLE `camps_for_servicing`(`cid` int(10) unsigned NOT NULL, PRIMARY KEY (`cid`), CONSTRAINT `fk__camps_for_servicing__cid` FOREIGN KEY (`cid`) REFERENCES `campaigns` (`cid`) ON DELETE CASCADE)'
    },
    {
      type => 'script',
      when => 'after',
      time_estimate => '5 sec',
      comment => 'заполняет новую таблицу camps_for_servicin, можно перезапускать'
    }
  ],
  approved_by => 'hmepas'
}

=cut

use Direct::Modern;

use my_inc '..';

use RBAC2::Extended;
use RBACDirect qw/ rbac_get_camps_for_servicing /;

use ScriptHelper;
use Settings;

use Yandex::DBShards qw/ sharded_chunks /;
use Yandex::DBTools qw/ do_mass_insert_sql /;

my $SUPERUSER_UID = 1;
my $CHUNK_SIZE    = 1_000;
my $SLEEP_COEF    = 0.5;

extract_script_params(
    'sleep-coef=f' => \$SLEEP_COEF,
);

$log->out('START');

my $rbac = RBAC2::Extended->get_singleton( $SUPERUSER_UID );
my $camps = rbac_get_camps_for_servicing( $rbac, $SUPERUSER_UID );

my $chunk_count    = 0;
my $total_inserted = 0;

for my $chunk ( sharded_chunks( cid => $camps, chunk_size => $CHUNK_SIZE, with_undef_shard => 1 ) ) {

    my $shard = $chunk->{shard} // -1;
    my @cids  = sort @{ $chunk->{cid} };

    unless ( $shard ) {
        $log->out( sprintf( "Can't guess shard for cid %s - campaigns might be under resharding, skip" => join( ', ' => @cids ) ) );
        next;
    }

    if ( $shard == -1 ) {
        $log->out( sprintf( "Can't guess shard for cids %s - no entries in ppcdict, skip" => join( ', ' => @cids ) ) );
        next;
    }

    my $msg_prefix_guard = $log->msg_prefix_guard("[shard $shard]");

    $log->out( sprintf( "\tchunk %s of size %s" => $chunk_count++, scalar @cids ) );

    my @data = map { [ $_ ] } @cids;

    $total_inserted += do_mass_insert_sql( PPC(shard => $shard),
      'INSERT IGNORE INTO `camps_for_servicing` (`cid`) VALUES %s', \@data, { sleep_coef => $SLEEP_COEF });
}

$log->out( sprintf( "%s rows inserted total" => $total_inserted ) );

$log->out('FINISH');
