#!/usr/bin/env perl

=head1 DEPLOY

# .migr
{
    approved_by => 'ppalex',
    tasks => [
        {
            type => 'script',
            when => 'after',
            time_estimate => "1m",
            comment => "можно перезапускать. На ТС запускать не обязательно"
        }
    ]
}

=cut

=pod

        Сборка данных описана в https://st.yandex-team.ru/DIRECT-80877#1529423966000

        Адекватность потом проверялась в скрипте:
        for my $currency (keys %$data) {
            say $currency;
            my $pids = $data->{$currency};
            local $, = "\n";
            say @{get_one_column_sql(PPC(pid => $pids), ["select currency from campaigns c join phrases p on c.cid = p.cid", where => {pid => SHARD_IDS}])};
            say @{get_one_column_sql(PPC(pid => $pids), ["select adgroup_type from phrases", where => {pid => SHARD_IDS}])};
        }
        Результат проверялся по логу на повторном запуске.

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;

use my_inc '..';

use Currencies;
use ScriptHelper;
use Settings;

$log->out('START');

# pid, которые нужно обновить, и их валюты.
my $data = {
    "BYN" => [3242898038,3244154341,3232235843,3232262908,3232266929,3232288857,3232288858,3256158158,3240521627,3240490432,3285168283,3233415234,3289734594,3318595424,3321475457,3296238122],
    "KZT" => [3318573831,3230480435,3280683125,3250992167,3240398729,3241011235,3241029219],
    "RUB" => [3225805609,3244919657,3244926230,3244932607,3244938479,3226230471,3226391478,3226397905,3227168685,3230783968,3230823015,3232322102,3232892735,3235545484,3237077334,3252440475,3242648161,
    3247984813,3248403787,3249319948,3261062687,3261083699,3262872576,3264527341,3280118013,3280120821,3282887281,3282094534,3300844496,3285308929,3286916694,3287680740,3288550619,3295414560,3301482906,
    3305072631,3306837750,3306956767,3307448028,3309139164,3312202883,3320833197,3325325514,3225770599,3226569080,3226584605,3227554293,3230902397,3242088030,3256753860,3233695813,3238001694,3240132112,
    3252822461,3240760642,3242631712,3258003421,3269877739,3270947565,3276985775,3278138288,3278275502,3278288838,3278297129,3278304300,3295389844,3303117941,3312786127,3279807110,3283281177,3329101101,
    3233231546,3236907607,3236919993,3238863782,3239065532,3240085151,3243333383,3255999951,3280301046,3281621425,3282023442,3245671320,3245899702,3245903296,3245904315,3246575976,3246582251,3246585725,
    3269969514,3269977017,3271746480,3271753624,3271761220,3302303718,3311296325,3314480970,3314487745,3314491419,3314497011,3314502260,3228177266,3256402175,3229008481,3232297977,3238148168,3238149899,
    3242068904,3257227327,3257274868,3261598527,3261597470,3261599780,3261600144,3262457811,3261599123,3261602914,3261603080,3261601160,3261609869,3261611251,3261613193,3261615472,3261616135,3261617033,
    3261618052,3261620135,3261620844,3273746040,3225766835,3225775876,3225792031,3226402684,3226431083,3240267162,3240326212,3249782218,3253176258,3259761069,3251264303,3262213533,3269351551,3269717591,
    3283020030,3312898117,3226457768,3226937514,3229802624,3229859879,3230000135,3238823849,3238826417,3238826477,3254307696,3256709559,3262714078,3262714970,3262715411,3262717665,3282837460,3322434044,
    3226414175,3226457276,3226696697,3227234112,3237242403,3237243539,3237244052,3237244116,3237244152,3237244626,3237244665,3237244743,3228268625,3228279172,3228285791,3228298994,3228302417,3231604280,
    3250983310,3258153851,3289528200,3260783544,3299846914,3299854954,3299988521,3305717598,3231084406,3243997176,3244001505,3244003910,3244012220,3233199560,3269433705,3237870274,3237872523,3237872540,
    3243690860,3245883061,3246848360,3260113220,3263060618,3267319322,3277419657,3295691270,3304751287,3313497036,3313502281,3228460856,3233751675,3242539440,3249393324,3267524562,3262816817,3262825062,
    3262826624,3262827818,3262828701,3262830866,3262831729,3262832914,3262833359,3262818873,3262839508,3262839884,3262841129,3262841923,3262823404,3265755685,3302735132,3311095777,3225688366,3226084261,
    3226116080,3226122725,3226436724,3228007973,3231194744,3233440553,3242236389,3275977612,3235494283,3238708046,3238709156,3238710305,3240169206,3240665398,3244081891,3268590152,3280638235,3283064572,
    3293072842,3302216226,3319355205,3319355206,3319355207,3319355208,3320288447,3321122697,3322357750,3228024191,3226867405,3229472030,3234019717,3237791332,3237791395,3229962390,3230845931,3237950053,
    3233102214,3234024988,3237391879,3247077914,3247268877,3251029638,3250729077,3254537091,3259712855,3254781334,3256437940,3256447813,3256453968,3256513992,3256796497,3258123674,3265264892,3269957696,
    3287547336,3287547337,3287547338,3302746683,3303876081,3307374328,3319545110,3319582585,3328525263,3329648727,3339582720,3130058997,3130059629,3225880960,3270960298,3226572229,3228071920,3228541473,
    3232688839,3232694318,3232697178,3232697740,3232700452,3232939554,3232956427,3232999625,3228647170,3229176621,3229887475,3231074144,3231116659,3231151400,3234919512,3233015594,3233015595,3233015596,
    3233015597,3233015598,3233015599,3233015601,3233015602,3233015603,3242048772,3245875490,3247598782,3247602036,3260529023,3272657986,3284080103,3286323953,3286555061,3286501711,3293719337,3294336103,
    3301266628,3302273364,3308056449,3308086392,3308086502,3308086731,3308086779,3308086904,3308086940,3308088209,3308088323,3308089655,3308089852,3308090451,3312221106,3362965725,3226505644,3226784883,
    3228452759,3228502178,3229024204,3229471913,3231529792,3235856895,3231884924,3231938124,3235133158,3235460663,3236318280,3237086824,3237092733,3237099082,3237111838,3237116934,3237117830,3237119434,
    3237873181,3237988059,3239540015,3239773937,3239941572,3241215977,3245236203,3245892661,3256168315,3248304698,3252544501,3260571329,3262219718,3265974177,3268228910,3269574313,3270891824,3273581464,
    3277446662,3277454594,3277456040,3277460501,3277464692,3277467472,3277469116,3277473133,3277476005,3277479906,3277487152,3277497390,3277509226,3277515868,3277518783,3277521920,3277524424,3277527769,
    3279139420,3280121221,3281007047,3281201569,3283020032,3283024438,3285091044,3286872730,3286878035,3287059888,3289957880,3296914069,3296929339,3298800443,3300397017,3304190144,3308282133,3305019528,
    3305019529,3305019530,3305021508,3305021512,3305021516,3305021519,3305021523,3305021526,3310646119,3312681256,3312751445,3312811349,3313701733,3313754244,3313790839,3313803991,3313832285,3313865815,
    3313936588,3315616997,3327077273,3327074453,3327075760,3327082272,3327081563,3327081898,3327082419,3327082566,3327079467,3327077700,3327078127,3319286616,3320250456,3322103207,3327080698,3327669347,
    3064235803,3226168560,3226218960,3226706860,3227264402,3227635084,3229028711,3232711685,3233028577,3234216416,3238331303,3238642186,3241464635,3249014683,3253807829,3254217998,3261307424,3261906294,
    3270021105,3262495303,3263667192,3265789285,3265798245,3268660041,3268661778,3269823982,3270723526,3270806964,3270859835,3272205668,3272205669,3272205670,3275986828,3275989985,3276037408,3276039802,
    3276052894,3276108113,3276128772,3276132859,3276138202,3276148016,3276169256,3286339751,3287352393,3296104644,3298248074,3303940248,3303942199,3303945697,3303945957,3303950230,3304508469,3305901554,
    3305980612,3305983604,3306998534,3321142063,3308639292,3318066965,3324071106,3326219024],
    "USD" => [3237634736,3237733021,3246818277,3246818278,3227046894,3227368316,3232057826,3241608691,3255609079,3264608301]
};

for my $currency (keys %$data) {
    my $min_price = get_currency_constant($currency, 'MIN_CPM_PRICE');
    my $value_string = "IF(price = 0, price, GREATEST(price, $min_price))";
    my $value_string_context = "IF(price_context = 0, price_context, GREATEST(price_context, $min_price))";
    $log->out("Going to update values for $currency with a minimum of $min_price");
    my $pids = $data->{$currency};
    while (my @pids_chunk = splice @$pids, 0, 20) {
        my $cids = get_one_column_sql(PPC(pid => \@pids_chunk), ["select cid from phrases", where => {pid => SHARD_IDS}]);
        for my $table (qw/bids bids_base bids_arc/) {
            my $id = $table ne 'bids_base' ? 'id' : 'bid_id';
            my $log_data = get_all_sql(PPC(pid => \@pids_chunk), ["select cid, pid, $id, price, price_context from $table", where => {pid => SHARD_IDS, cid => $cids}]);
            $log->out({data => $log_data, table => $table});
            my $bids_count = do_update_table(PPC(pid => \@pids_chunk), $table, {price__dont_quote => $value_string, price_context__dont_quote => $value_string_context},
                where => {pid => SHARD_IDS, cid => $cids});
            $log->out("updated " . (0 + $bids_count) . " rows");
        }
    }
}

$log->out('FINISH');
