#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'manual',
      when => 'after',
      time_estimate => '1 час',
      instructions => 'запускать по просьбе santama@',
      when => 'instructions',
      text => 'Запускать без параметров:
/var/www/ppc.yandex.ru/deploy/20180702_enlarge_super_resolution_formats_between_225_and_450.pl
Если надо замедлить: есть параметр --relaxed
      ',
    }
  ],
  approved_by => 'zhur'
}

=cut


use my_inc '..';
use Direct::Modern;

use ScriptHelper;
use Settings;
use Yandex::DBShards;
use Yandex::DBTools;
use Yandex::HashUtils qw/hash_cut/;
use Yandex::ListUtils qw/chunks/;
use Yandex::Retry qw/relaxed_guard/;
use Yandex::YT::Table;
use Tools;

# https://st.yandex-team.ru/DIRECT-81698: Отсуперрезить картинки размером от 225 по большей стороне до 450 по меньшей стороне
# 1. Выбрал картинки размером от 225 по большей стороне до 450 по меньшей стороне https://yql.yandex-team.ru/Operations/5b18161d3a3841903cc39161?editor_page=main
# 2. Применил SR к выбранным картинкам
# 3. Залил картинки в аватарницу, получив таблицу с meta json
# 4. Выгрузил в YT shard_client_id: direct-sql -B pr:ppcdict "select * from shard_client_id" | tail -n +2 | yt --proxy hahn.yt.yandex.net write --format "<columns=[ClientID;shard]>schemaful_dsv" "//home/direct/test/santama/client_shard"
# 5. Подготовил табличку [//home/direct/test/santama/bif_sr_225_to_450] для скармливания скрипту миграции: https://yql.yandex-team.ru/Operations/Wxk5_za9vA6XX68m0sJ1ddJi1u_0SAJoYPv8gldMH84=
# 6. Подготовил табличку [//home/direct/test/santama/bif_sr_225_to_450_with_banners_count] для ограничения количества обновляемых за раз баннеров: https://yql.yandex-team.ru/Operations/Wz4fwvvJNbcRuSoKCEmuDSteMRrLzJ0Cj6Fue8JRiA8=
# Обновление затронет ~ 160_000 картинок и ~ 3_500_000 баннеров https://yql.yandex-team.ru/Operations/Wxk_CPvJNdnH7fdqBisD9BT8dAuuzel1xF3S2LgPZq4=
# Здесь про локальное улучшение откручиваемых в данный момент картинок с изменением image_hash , image_type и formats и без изменений в коде
# Изменение состава тумб в formats а также image_type со small на regular произойдет за счет того, что в результате увеличения все указанные картинки станут больше 450, при этом сейчас у всех них размер до 450

$Yandex::YT::Streaming::DEFAULT_FORMAT = 'json';

# Запрос, формирующий таблицу 'hahn.[//home/direct/test/santama/bif_sr_225_to_450]'
# https://yql.yandex-team.ru/Operations/5b1939ff36bdbc0e975faf26?editor_page=main
# Запрос, формирующий таблицу 'hahn.[//home/direct/test/santama/bif_sr_225_to_450_with_banners_count]'
# https://yql.yandex-team.ru/Operations/Wz4fwvvJNbcRuSoKCEmuDSteMRrLzJ0Cj6Fue8JRiA8=
my $yt_table   = '//home/direct/test/santama/bif_sr_225_to_450_with_banners_count';
my $yt_cluster = 'hahn';
my $offset     = 0;
my $limit      = 0;
my $relaxed    = 1;
my $chunk_size = 1000;

$log->out('START');

extract_script_params(
    'offset=i'      => \$offset,
    'limit=i'       => \$limit,
    'cluster=s'     => \$yt_cluster,
    'table=s'       => \$yt_table,
    'chunksize=i'   => \$chunk_size,
    'relaxed=s'     => \$relaxed,
);

my $total_inserted_banner_images_formats = 0;
my $total_images_updated                 = 0;

if ($limit) {
    $log->out( sprintf( 'limit on images amount is given - %s' => $limit ) );
}

if ($offset) {
    $log->out( sprintf( 'offset is given - %s' => $offset ) );
}

Tools::force_set_yt_environment($yt_cluster);

my $table = Yandex::YT::Table->new($yt_table);
unless ($table->exists()) {
    $log->die("table $yt_table doesn't exists");
}

my @image_list_buffer;
my $end_row_num = $limit > 0 ? '#' . ($offset + $limit) : '';
my $reader = $table->reader(undef, "[#$offset:${end_row_num}]", format => "json");
while ( my $r = $reader->next() ) {


    push @image_list_buffer, $r;

    if ( @image_list_buffer >= $chunk_size ) {
        proccess_images( \@image_list_buffer );
        @image_list_buffer = ();
    }

}

if ( @image_list_buffer ) {
    proccess_images( \@image_list_buffer );
}

$log->out('FINISH');

sub proccess_images {
    my $images = shift;

    my %sharded_images;
    for (@$images) {
        push @{ $sharded_images{$_->{shard}} }, $_;
    }
    foreach_shard shard => [keys %sharded_images], sub {
            my ($shard) = @_;

            my @shard_images = @{ $sharded_images{$shard} };

            my $msg_prefix_guard = $log->msg_prefix_guard("[shard $shard]");
            $log->out( sprintf('%s images to insert', scalar(@shard_images) ) );

            my $rg = relaxed_guard times => $relaxed;

            insert_super_resolution_images( $shard, \@shard_images );

            my @chunked_shard_images;
            my $chunk_banners_count = 0;
            foreach my $shard_image (@shard_images) {
                push @chunked_shard_images, $shard_image;
                $chunk_banners_count += $shard_image->{banners_count};
                if ($chunk_banners_count > 1_000) {
                    update_banner_images($shard, \@chunked_shard_images);
                    @chunked_shard_images = ();
                    $chunk_banners_count = 0;
                }
            }
            if ( @chunked_shard_images ) {
                update_banner_images($shard, \@chunked_shard_images);
            }
        };
    $log->out( sprintf( '%s banner_images_formats rows inserted so far' => $total_inserted_banner_images_formats ) );
    $log->out( sprintf( '%s banner_images rows updated so far' => $total_images_updated ) );
}

$log->out( sprintf( 'total %s banner_images_formats rows inserted' => $total_inserted_banner_images_formats ) );
$log->out( sprintf( 'total %s banner_images rows updated' => $total_images_updated ) );
$log->out('FINISH');


sub insert_super_resolution_images {
    my ( $shard, $images ) = @_;

    my $size = scalar @$images;

    return unless $size;

    my @to_insert;
    foreach my $image (@$images) {
        push @to_insert, [ $image->{image_hash}, $image->{mds_group_id}, $image->{namespace},
                $image->{image_type}, $image->{width}, $image->{height}, $image->{formats},
                $image->{avatars_host} ];
    }

    my $res = do_mass_insert_sql(PPC(shard => $shard),
        'insert ignore into banner_images_formats (image_hash, mds_group_id, namespace, image_type, width, height, formats, avatars_host) values %s', \@to_insert);

    $total_inserted_banner_images_formats += $res;

    return $res;
}

sub update_banner_images {
    my ( $shard, $images ) = @_;

    my $size = scalar @$images;

    return unless $size;

    $log->out({'update_banner_images' => [ map { hash_cut($_, qw/image_hash parent_image_hash/) } @$images ]});
    my %parent_image_hash_to_image_hash = map {$_->{parent_image_hash} => { image_hash => $_->{image_hash} }} @$images;

    do_in_transaction {
        my $res = do_mass_update_sql(PPC(shard => $shard), 'banner_images', 'image_hash', \%parent_image_hash_to_image_hash);
        do_mass_update_sql(PPC(shard => $shard), 'ignore banner_images_pool', 'image_hash', \%parent_image_hash_to_image_hash);
        $total_images_updated += $res;
    }

}


