#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  approved_by => 'zhur',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => 'менее 1 min',
      comment => ''
    }
  ]
}

=cut

use Direct::Modern;

use my_inc '..';

use JSON qw/to_json/;
use geo_regions q//;
use PrimitivesIds qw/get_uid2login/;
use ScriptHelper;
use Settings;
use User;
use Yandex::Balance qw/get_clientid_by_uid balance_create_client create_client_id_association remove_client_id_association/;
use Yandex::DBShards qw/get_shard get_shard_multi delete_shard save_shard/;
use Yandex::DBTools qw/get_one_line_sql do_sql/;
use Yandex::ListUtils qw/xisect/;


my $DO          = 1;
my @UIDS2DELETE = (32042672, 43723396, 75712410, 231404575, 248162369, 292412419, 397375756, 403026233, 423855728, 456257517, 582231869, 604431508, 650955809);
my @UIDS2MOVE   = (269143085, 273468477, 419793491);

if ( scalar @{ xisect( \@UIDS2DELETE, \@UIDS2MOVE ) } ) {
    say "Both options --delete-uid and --move-uid contains the same uid!";
    usage();
}


$log->out('START');

my $uids = [ @UIDS2DELETE, @UIDS2MOVE ];
my $uid2shard = get_shard_multi(uid => $uids);
my $uid2login = get_uid2login(uid => $uids);

for my $uid ( @UIDS2DELETE ) {
	unless ( exists $uid2login->{ $uid } && exists $uid2shard->{ $uid } ) {
		$log->out("Seems that uid $uid already deleted, skip it!");
		next;
	}
	delete_user_from_ppc( $uid, $uid2login->{ $uid }, $uid2shard->{ $uid } );
}

for my $uid ( @UIDS2MOVE ) {
	unless ( exists $uid2login->{ $uid } && exists $uid2shard->{ $uid } ) {
		$log->out("Seems that uid $uid not exists, skip it!");
		next;
	}
	move_to_new_client_internal_role( $uid, $uid2login->{ $uid }, $uid2shard->{ $uid } );
}

$log->out('FINISH');


sub delete_user_from_ppc {
    my ( $uid, $login, $shard ) = @_;

    my %DATA = (
    	shard => $shard,
    	login => $login,
    );
    
    for my $table ( sort keys %User::USER_TABLES ) {
        $DATA{ $table } = get_one_line_sql( PPC(shard => $shard), "SELECT * FROM $table WHERE uid = ?", $uid );
    }
    $log->out( 'DELETE_USER: '. to_json( \%DATA ) );
    
    if ( $DO ) {
	    for my $table ( sort keys %User::USER_TABLES ) {
	        do_sql( PPC(shard => $shard), "DELETE FROM $table WHERE uid = ?", $uid );
	    }
	    
	    delete_shard(uid => $uid);
	    
	    if ( $login && get_shard(login => $login, 'uid') == $uid ) {
	        delete_shard(login => $login);
	    }
	}
}

sub move_to_new_client_internal_role {
    my ( $uid, $login, $shard ) = @_;

	$log->out("Move uid $uid to new client");

    return unless $DO;
    
    my ( $error, $new_client_id ) = balance_create_client( $uid, {
        NAME    => '-',
        PHONE   => '-',
        FAX     => '-',
        EMAIL   => '-',
        CITY    => '-',
        URL     => '-',
        CLIENT_TYPE_ID => 0,
        IS_AGENCY => 0,
        REGION_ID => $geo_regions::RUS,
        CURRENCY  => 'RUB',
   	});

	die "Balance error: $error" if $error;

    $log->out("created client $new_client_id");

    do_sql( PPC(shard => $shard), 'INSERT IGNORE INTO clients (ClientID, work_currency) VALUES (?, ?)', $new_client_id, 'RUB' );
    $log->out("insert into clients $new_client_id");

    do_sql( PPC(shard => $shard), 'UPDATE users SET ClientID = ? WHERE uid = ?', $new_client_id, $uid );
    $log->out("update users $new_client_id");

	my $client_id = get_clientid_by_uid( $uid );
    remove_client_id_association( $uid, $client_id, $uid ) if $client_id;

    create_client_id_association( $uid, $new_client_id, $uid );

    # save shard
    save_shard( ClientID => $new_client_id, shard => $shard );
    save_shard( uid => $uid, ClientID => $new_client_id );
    
    return $new_client_id;
}
