#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
    tasks => [
        {
            type => 'script',
            when => 'after',
            time_estimate => "2–3 часа"
        },
        {
            type => 'sql',
            db => "ppc:1",
            when => 'any',
            time_estimate => "1s",
            sql => "UPDATE mod_mail_candidates SET status = 'Recheck' WHERE ClientID = 315187 AND cid = 0"
        },
        {
            type => 'sql',
            db => "ppc:15",
            when => 'any',
            time_estimate => "1s",
            sql => "UPDATE mod_mail_candidates SET status = 'Recheck' WHERE ClientID = 41286428 AND cid = 34476383"
        }
    ],
    approved_by => 'ppalex'
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;

use Moderate::Mail qw/get_cid_clientid_where_condition/;
use ShardingTools;
use Yandex::ListUtils qw/chunks/;

my $DELETE_CHUNK = 500;

my @SHARDS;
extract_script_params(
    'shard-id:i' => \@SHARDS,
);
@SHARDS = ppc_shards() if !@SHARDS;

$log->out('START');
for my $shard (@SHARDS) {
    # удаляем записи из mod_reasons, ссылающиеся на несуществующие кампании
    $log->out("Processing shard $shard");
    my $mmc_delete = get_all_sql(PPC(shard => $shard), "SELECT mr.* FROM mod_reasons mr
        LEFT JOIN campaigns c ON c.cid = mr.cid
        WHERE mr.statusSending != 'Yes' AND c.cid IS NULL AND mr.cid > 0");
    $log->out({description => 'rows from mod_reasons to delete', data => $mmc_delete});
    for my $chunk (chunks($mmc_delete, $DELETE_CHUNK)) {
        my $rows_deleted = do_delete_from_table(PPC(shard => $shard), 'mod_reasons', where => get_cid_clientid_where_condition($chunk));
        $log->out('deleted ' . (0 + $rows_deleted) . ' rows');
    }

    # всему неудалённому из mod_reasons припишем парную запись в mod_mail_candidates, если её нет
    my $mmc_insert = get_all_sql(PPC(shard => $shard), "SELECT DISTINCT mr.ClientID, mr.cid FROM mod_reasons mr
        LEFT JOIN mod_mail_candidates mmc ON mmc.cid = mr.cid AND mmc.ClientID = mr.ClientID
        WHERE mr.statusSending != 'Yes' AND mmc.cid IS NULL");
    $log->out({msg => "Inserting to mod_mail_candidates", ids => $mmc_insert});
    do_mass_insert_sql(
        PPC(shard => $shard),
        q/insert ignore into mod_mail_candidates (ClientID, cid) values %s/,
        [map {[$_->{ClientID}, $_->{cid}]} @$mmc_insert],
        {dont_quote => 1}
    );

    $log->out("Finished shard $shard");
}
$log->out('FINISH');
