#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'instructions',
      instructions => "
                  запускать по просьбе aleran@
                  перед запуском нужно привезти файл с маппингом
                  scp ppcdev5:/home/aleran/video_addition_preset_mapping.csv .
                  путь к этому файлу нужно будет указать в параметрах запуска,
                  ./20180727_fill_perf_creative_layout_id.pl video_addition_preset_mapping.csv",
      time_estimate => "на devtest 20 минут",
      comment => "можно перезапускать"
    }
  ],
  approved_by => 'hrustyashko'
}

=head1 DESCRIPTION

    Читает из файла preset_id креативов. Одна строка в файле creative_id,preset_id
    Заменяет preset_id=6 на preset_id=5

    Параметры
        <file> - путь к файлу

    Опции:
        --force-presets - убирает переопределение 6-го пресета. Записывает его, как в файле.

    Опции только для тестирования на бете:
        --creative-id - обрабатывать только указанные креативы. Выбирает из файла только указанные идетификаторы

=cut

use Direct::Modern;

use Yandex::Retry qw/relaxed/;
use Yandex::DBTools;
use Yandex::DBShards;

use my_inc '..';

use EnvTools;
use ScriptHelper 'Yandex::Log' => 'messages';
use Settings;

$log->out('START');
my @creative_ids;
my $FORCE_PRESETS = 0;

extract_script_params(
    'creative-id=i@' => \@creative_ids,
    'force-presets' => \$FORCE_PRESETS,
);

my $filename = $ARGV[0];
unless ($filename && -f $filename) {
    usage();
}
if (!is_beta()) {
    if (@creative_ids) {
        $log->die("--creative-id is beta only!");
    }
}

my $SLEEP_COEF = 2;
my $PROCESS_CHUNK_SIZE = 1000;

my $creative_to_preset_id = read_file($filename, \@creative_ids);

for my $chunk (sharded_chunks( creative_id =>[keys %$creative_to_preset_id], chunk_size => $PROCESS_CHUNK_SIZE)) {
    my $shard = $chunk->{shard};
    my $creative_ids = $chunk->{creative_id};
    my %chuncked_creatives = map {$_ => $creative_to_preset_id->{$_}} @$creative_ids;
    $log->msg_prefix("[shard $shard]");
    relaxed times => $SLEEP_COEF, sub {
            $log->out("update data chunk for creative_ids: " . join(',', @$creative_ids));
            my $res = int do_update_table(PPC(shard => $shard), 'perf_creatives',
                    { layout_id__dont_quote =>
                        sql_case(creative_id => \%chuncked_creatives) },
                    where => {
                        creative_type => 'video_addition',
                        creative_id => $creative_ids
                    }
                );
            $log->out("updated rows: $res");
        };
    %chuncked_creatives = ();
}
$log->msg_prefix('');
$log->out('FINISH');

sub read_file {
    my ($filename, $creative_ids) = @_;
    my $result = {};

    open(my $fh, "<:utf8", $filename);
    unless ($fh) {
        $log->die("can't open $filename");
    }

    my $creatives = @$creative_ids ? { map { $_ => undef } @$creative_ids } : undef;
    while (<$fh>) {
        chomp;
        my ($creative_id, $preset_id) = $_ =~ /^(\d+),(\d+)$/;

        if (!$creative_id || !$preset_id) {
            $log->die("bad row format '$_' at $.");
        }

        next if defined $creatives && !exists $creatives->{$creative_id};

        if ($preset_id == 6 && !$FORCE_PRESETS) {
            $preset_id = 5; #https://st.yandex-team.ru/DIRECT-82770#1533640282000
        }
        $result->{$creative_id} = $preset_id;
    }
    close($fh);

    return $result;
}

