#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "несколько секунд",
      comment => "Можно перезапускать"
    }
  ],
  approved_by => 'gukserg'
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;

use my_inc '..';

use ScriptHelper;
use Settings;

my $DELETE_CHUNK = 500;

my $shard2id = {
    13 => [
        1269659,1269661,1269662,1269668,1269670,1269671,1269674,1269675,1269677,1269680,1269681,1269685,1269687,1269689,1269690,1269691,1269692,1269696,1269697,1269698,
        1269699,1269702,1269704,1269706,1269708,1269709,1269711,1269712,1269714,1269715,1269716,1269717,1269718,1269719,1269720,1269721,1269727,1269729,1269730,1269731,
        1269733,1269745,1269747,1269748,1269749,1269752,1268663,1268665,1268668,1268670,1268673,1268684,1268690,1268693,1268696,1268699,1268703,1268709,1268714,1268717,
        1268721,1268723,1268726,1268737,1268741,1268743,1268746,1268748,1268755,1268761,1268766,1268769,1268770,1268772,1268775,1268813,1268815,1268816,1268817,1268818,
        1268819,1268822,1268824,1268827,1268831,1268834,1268835,1268836,1268839,1268840,1268841,1268844,1268845,1268969,1269031,1269032,1269034,1269036,1269038,1269042,
        1269045,1269046,1269047,1269048,1269050,1269068,1269096,1269097,1269099,1269118,1269138,1269172,1269174,1269175,1269176,1269177,1269178,1269179,1269180,1269184,
        1269185,1269186,1269187,1269191,1269192,1269193,1269194,1269195,1269252,1269272,1269275,1269277,1269278,1269279,1269280,1269281,1269284,1269287,1269288,1269291,
        1269295,1269298,1269299,1269300,1269301,1269303,1269304,1269306,1269308,1269318,1269327,1269331,1269332,1269337,1269338,1269339,1269342,1269345,1269346,1269349,
        1269356,1269361,1269362,1269363,1269364,1269365,1269366,1269369,1269372,1269375,1269377,1269378,1269379,1269382,1269383,1269385,1269386,1269387,1269389,1269391,
        1269392,1269394,1269396,1269398,1269400,1269401,1269404,1269407,1269408,1269410,1269412,1269415,1269416,1269418,1269419,1269420,1269421,1269423,1269424,1269425,
        1269427,1269428,1269429,1269433,1269434,1269437,1269440,1269442,1269444,1269445,1269447,1269450,1269451,1269452,1269454,1269455,1269458,1269459,1269460,1269461,
        1269463,1269465,1269466,1269468,1269472,1269475,1269476,1269478,1269480,1269549,1269553,1269556,1269558,1269559,1269560,1269561,1269562,1269563,1269564,1269569,
        1269574,1269577,1269586,1269587,1269589,1269590,1269593,1269594,1269599,1269602,1269608,1269609,1269611,1269614,1269615,1269618,1269620,1269622,1269624,1269626,
        1269627,1269628,1269631,1269632,1269633,1269637,1269639,1269641,1269642,1269643,1269646,1269649,1269650,1269653,1269654,1269658,1269663,1269669,1269672,1269673,
        1269676,1269684,1269688,1269693,1269700,1269701,1269705,1269707,1269710,1269713,1269728,1269732,1269753,1269757,1269758,1269759,1269760,1269771,1269778,1269779,
        1269780,1269784,1269785,1269788,1269789,1269790,1269791,1269792,1269797,1269798,1269800,1269801,1269802,1269804,1269806,1269808,1269809,1269811,1269812,1269815,
        1269816,1269817,1269818,1269819,1269820,1269821,1269824,1269828,1269834,1269837,1269838,1269846,1269847,1269850,1269851,1269852,1269853,1269854,1269855,1269856,
        1269857,1269859,1269860,1269861,1269862,1269863,1269864,1269865,1269869,1269870,1269871,1269872,1269873,1269874,1269878,1269879,1269880,1269881,1269882,1269883,
        1269884,1269885,1269891,1269892,1269895,1269896,1269898,1269900,1269904,1269907,1269908,1269911,1269912,1269913,1269915,1269917,1269918,1269919,1269920,1269921,
        1269922,1269923,1269924,1269925,1269926,1269927,1269928,1269929,1269930,1269931,1269932,1269933,1269934,1269935,1269936,1269937,1269938,1269955,1269964,1269965,
        1269966,1269967,1269968,1269973,1269974,1269975,1269976,1269977,1269978,1269979,1269980,1269985,1269988,1269990,1269994,1269995,1269996,1269998,1270002,1270011,
        1270012,1270013,1270016,1270019,1270020,1270021,1270022,1270023,1270024,1270025,1270026,1270027,1270030,1270031,1270032,1270033,1270034,1270042,1270045,1270046,
        1270047,1270048,1270049,1270050,1270051,1270052,1270057,1270060,1270062,1270063,1270064,1270065,1270066,1270067,1270068,1270069,1270070,1270071,1270072,1270073,
        1270074,1270076,1270077,1270078,1270079,1270081,1270085,1270086,1270087,1270090,1270091,1270092,1270094,1270095,1270096,1270097,1270098,1270101,1270103,1270104,
        1270105,1270106,1270107,1270108,1270109,1270110,1270111,1270112,1270113,1270114,1270115,1270117,1270118,1270120,1270121,1270122,1270123,1270127,1270128,1270129,
        1270130,1270133,1270134,1270136,1270137,1270138,1270139,1270140,1270142,1270144,1270145,1270146,1270147,1270149,1270151,1270152,1270153,1270161,1270162,1270163,
        1270164,1270170,1270172,1270174,1270175,1270176,1270177,1270180,1270183,1270186,1270188,1270189,1270190,1270191,1270192,1270193,1270194,1270195,1270196,1270198,
        1270202,1270206,1270207,1270208,1270209,1270210,1270211,1270212,1270213,1270214,1270215,1270216,1270217,1270218,1270219,1270222,1270224,1270226,1270227,1270228,
        1270230,1270232,1270233,1270234,1270235,1270236,1270237,1270238,1270239,1270240,1270241,1270242,1270243,1270244,1270245,1270246,1270247,1270248,1270249,1270250,
        1270251,1270252,1270253,1270254,1270256,1270257,1270258,1270259,1270260,1270261,1270262,1270263,1270264,1270265,1270266,1270267,1270268,1270269,1270270,1270271,
        1270272,1270273,1270274,1270275,1270276,1270277,1270278,1270279,1270280,1270281,1270282,1270283,1270284,1270285,1270286,1270287,1270288,1270289,1270290,1270291,
        1270292,1270293,1270294,1270295,1270296,1270297,1270298,1270299,1270300,1270301,1270302,1270303,1270304,1270305,1270307,1270308,1270309,1270310,1270311,1270312,
        1270313,1270314,1270315,1270316,1270317,1270318,1270319,1270320,1270321,1270322,1270323,1270324,1270325,1270326,1270327,1270328,1270329,1270330,1270331,1270332,
        1270333,1270334,1270335,1270336,1270337,1270338,1270339,1270340,1270341,1270342,1270343,1270344,1270345,1270346,1270347,1270348,1270349,1270350,1270351,1270352,
        1270355,1270356,1270357,1270358,1270359,1270360,1270361,1270362,1270363,1270364,1270365,1270366,1270367,1270368,1270369,1270370,1270371,1270372,1270373,1270374,
        1270375,1270376,1270377,1270378,1270379,1270380,1270381,1270382,1270383,1270384,1270385,1270387,1270388,1270389,1270390,1270391,1270394,1270395,1270396,1270397,
        1270399,1270400,1270401,1270403,1270404,1270405,1270406,1270407,1270408,1270409,1270508,1270515,1270522,1270523,1270524,1270531,1270534,1270537,1270555,1270563,
        1270564,1270565,1270566,1270567,1270568,1270570,1270573,1270574,1270575,1270576,1270577,1270578,1270579,1270580,1270582,1270583,1270584,1270585,1270586,1270587,
        1270590,1270591,1270592,1270593,1270594,1270595,1270598,1270599,1270602,1270603,1270604,1270605,1270606,1270607,1270610,1270611,1270612,1270613,1270615,1270616,
        1270617,1270618,1270619,1270620,1270621,1270622,1270624,1270625,1270626,1270627,1270629,1270630,1270631,1270632,1270634,1270635,1270636,1270637,1270638,1270639,
        1270640,1270641,1270642,1270643,1270644,1270645,1270646,1270647,1270648,1270649,1270650,1270651,1270652,1270653,1270654,1270655,1270656,1270657,1270658,1270659,
        1270660,1270661,1270662,1270663,1270664,1270665,1270666,1270667,1270668,1270669,1270670,1270671,1270672,1270673,1270678,1270688,1270722,1270723,1270724,1270725,
        1270728,1270730,1270732,1270736,1270737,1270773,1270800,1270807,1270808,1270809,1270810,1270811,1270812,1270813,1270814,1270815,1270816,1270817,1270818,1270819,
        1270820,1270821,1270822,1270873,1270874,1270875,1270876,1270877,1270878,1270879,1270880,1270881,1270882,1270883,1270884,1270885,1270886,1270887,1270888,1270889,
        1270890,1270891,1270892,1270893,1270894,1270895,1270896,1270897,1270898,1270899,1270900,1270901,1270902,1270903,1270904,1270905,1270919,1270930,1270931,1270932,
        1270933,1270934,1270935,1270936,1270937,1270938,1270939,1270940,1270941,1270942,1270943,1270944,1270945,1270948,1270951,1270958,1270967,1270969,1270971,1270998,
        1270999,1271000,1271002,1271003,1271004,1271005,1271006,1271007,1271008,1271009,1271010,1271011,1271012,1271013,1271014,1271015,1271016,1271017,1271018,1271019,
        1271020,1271021,1271022,1271023,1271070,1271074,1271075,1271076,1271079,1271137,1271139,1271140,1271141,1271142,1271143,1271144,1271145,1271146,1271147,1271148,
        1271149,1271150,1271151,1271152,1271161,1271162,1271163,1271164,1271166,1271167,1271170,1271173,1271174,1271175,1271176,1271177,1271178,1271179,1271180,1271181,
        1271182,1271183,1271185,1271187,1271188,1271189,1271190,1271191,1271192,1271193,1271194,1271195,1271196,1271197,1271198,1271199,1271200,1271201,1271237,1271238,
        1271241,1271248,1271249,1271251,1271252,1271253,1271254,1271255,1271256,1271257,1271258,1271259,1271260,1271262,1271263,1271264,1271265,1271266,1271267,1271268,
        1271269,1271270,1271271,1271278,1271281,1271283,1271285,1271288,1271290,1271302,1271406,1271420,1271421,1271422,1271423,1271424,1271425,1271427,1271428,1271429,
        1271430,1271431,1271432,1271433,1271434,1271435,1271436,1271437,1271438,1271439,1271441,1271442,1271443,1271448,1271455,1271456,1271457,1271458,1271459,1271460,
        1271461,1271462,1271463,1271464,1271465,1271466,1271467,1271468,1271469,1271470,1271471,1271472,1271473,1271474,1271475,1271476,1271477,1271478,1271479,1271480,
        1271481,1271482,1271483,1271484,1271485,1271486,1271487,1271488,1271489,1271490,1271491,1271492,1271493,1271494,1271495,1271496,1271497,1271498,1271499,1271500,
        1271501,1271502,1271503,1271504,1271505,1271506,1271507,1271508,1271509,1271510,1271511,1271512,1271513,1271524,1271530,1271531,1271534,1271535,1271536,1271537,
        1271538,1271539,1271540,1271541,1271542,1271543,1271544,1271545,1271546,1271547,1271548,1271549,1271550,1271551,1271552,1271553,1271554,1271555,1271556,1271557,
        1271558,1271559,1271560,1271561,1271562,1271563,1271564,1271565,1271566,1271567,1271568,1271569,1271570,1271571,1271572,1271573,1271574,1271575,1271576,1271577,
        1271578,1271579,1271580,1271581,1271582,1271584,1271585,1271586,1271587,1271588,1271589,1271590,1271591,1271592,1271593,1271594,1271595,1271596,1271597,1271598,
        1271599,1271600,1271601,1271602,1271603,1271604,1271605,1271606,1271607,1271608,1271609,1271610,1271611,1271614,1271615,1271616,1271617,1271618,1271619,1271620,
        1271621,1271622,1271623,1271624,1271625,1271626,1271627,1271628,1271629,1271630,1271631,1271632,1271633,1271634,1271635,1271636,1271637,1271638,1271639,1271640,
        1271641,1271642,1271643,1271644,1271645,1271646,1271647,1271648,1271649,1271650,1271651,1271652,1271653,1271654,1271656,1271658,1271659,1271660,1271662,1271663,
        1271664,1271665,1271666,1271667,1271668,1271669,1271670,1271671,1271672,1271673,1271674,1271675,1271676,1271677,1271678,1271679,1271680,1271681,1271682,1271683,
        1271684,1271718,1271723,1271724,1271725,1271726,1271727,1271728,1271729,1271730,1271731,1271732,1271733,1271734,1271735,1271736,1271737,1271738,1271739,1271740,
        1271741,1271742,1271743,1271744,1271745,1271746,1271747,1271748,1271749,1271751,1271752,1271753,1271754,1271755,1271756,1271757,1271758,1271759,1271760,1271761,
        1271762,1271763,1271764,1271765,1271766,1271767,1271768,1271769,1271770,1271771,1271772,1271773,1271774,1271775,1271776,1271777,1271778,1271779,1271780,1271781,
        1271782,1271783,1271784,1271785,1271786,1271787,1271788,1271789,1271790,1271791,1271792,1271793,1271794,1271795,1271796,1271797,1271798,1271799,1271800,1271801,
        1271802,1271803,1271804,1271805,1271810,1271811,1271812,1271813,1271814,1271815,1271816,1271817,1271818,1271819,1271820,1271821,1271822,1271823,1271824,1271825,
        1271826,1271827,1271828,1271829,1271830,1271831,1271832,1271833,1271834,1271835,1271836,1271837,1271838,1271839,1271840,1271841,1271842,1271844,1271845,1271846,
        1271847,1271848,1271849,1271850,1271851,1271852,1271853,1271854,1271855,1271856,1271857,1271858,1271859,1271860,1271861,1271862,1271863,1271864,1271865,1271866,
        1271867,1271868,1271869,1271870,1271871,1271872,1271873,1271874,1271875,1271876,1271887,1271888,1271889,1271890,1271891,1271892,1271893,1271897,1271905,1271908,
        1271909,1271910,1271911,1271912,1271913,1271914,1271915,1271916,1271917,1271918,1271919,1271920,1271921,1271922,1271923,1271924,1271925,1271926,1271927,1271928,
        1271929,1271930,1271931,1271932,1271933,1271934,1271935,1271936,1271937,1271938,1271939,1271940,1271941,1271942,1271943,1271944,1271945,1271946,1271947,1271948,
        1271949,1271950,1271951,1271952,1271953,1271954,1271955,1271956,1271957,1271958,1271959,1271960,1271961,1271962,1271963,1271964,1271965,1271966,1271967,1271968,
        1271969,1271970,1271971,1271972,1271973,1271974,1271979,1271980,1271981,1271982,1271983,1272057,1272058,1272059,1272060,1272061,1272062,1272063,1272064,1272065,
        1272069,1272070,1272071,1272072,1272073,1272074,1272075,1272076,1272077,1272078,1272079,1272080,1272081,1272082,1272083,1272084,1272085,1272086,1272087,1272088,
        1272089,1272090,1272091,1272092,1272093,1272094,1272095,1272096,1272097,1272098,1272103,1272104,1272105,1272106,1272107,1272110,1272111,1272112,1272113,1272114,
        1272115,1272116,1272117,1272118,1272119,1272120,1272121,1272122,1272123,1272124,1272125,1272152,1272163,1272185,1272186,1272187,1272188,1272189,1272190,1272191,
        1272192,1272193,1272194,1272195,1272196,1272197,1272198,1272199,1272200,1272203,1272204,1272205,1272206,1272207,1272210,1272211,1272212,1272213,1272214,1272215,
        1272216,1272217,1272218,1272219,1272220,1272221,1272222,1272223,1272224,1272225,1272226,1272227,1272229,1272233,1272237,1272238,1272239,1272240,1272241,1272243,
        1272244,1272245,1272246,1272247,1272248,1272249,1272252,1272253,1272254,1272256,1272257,1272258,1272259,1272260,1272292,1272322,1272323,1272324,1272325,1272326,
        1272327,1272328,1272331,1272332,1272333,1272334,1272335,1272336,1272337,1272338,1272339,1272340,1272341,1272342,1272343,1272344,1272345,1272346,1272347,1272348,
        1272349,1272350,1272351,1272354,1272355,1272356,1272357,1272358,1272359,1272361,1272362,1272363,1272364,1272365,1272366,1272367,1272368,1272370,1272371,1272372,
        1272377,1272378,1272379,1272380,1272402,1272403,1272437,1272487,1272488,1272577,1272689,1272720,1272721,1272722,1272723,1272745,1272748,1272749,1272750,1272752,
        1272753,1272754,1272755,1272756,1272757,1272759,1272761,1272762,1272763,1272764,1272765,1272766,1272812,1272813,1272814,1272815,1272816,1272817,1272818,1272819,
        1272820,1272821,1272822,1272823,1272824,1272825,1272826,1272827,1272830,1272831,1272832,1272833,1272834,1272835,1272836,1272838,1272839,1272840,1272841,1272842,
        1272843,1272844,1272845,1272846,1272847,1272848,1272849,1272850,1272851,1272852,1272853,1272854,1272886,1272888,1272930,1272931,1272932,1272933,1272934,1272935,
        1272936,1272937,1272938,1272939,1272940,1272941,1272942,1272943,1272944,1272945,1272946,1272947,1272948,1272949,1272950,1272951,1272952,1272953,1272954,1272955,
        1272956,1272957,1272958,1272959,1272960,1272961,1272962,1272963,1272964,1272965,1272966,1272967,1272968,1272969,1272970,1272971,1272972,1272973,1272974,1272975,
        1272976,1272977,1272978,1272979,1272980,1272981,1272982,1272983,1272984,1272985,1272986,1272987,1272988,1272989,1272990,1272991,1272992,1272993,1272994,1272995,
        1272996,1272997,1272998,1272999,1273000,1273001,1273002,1273003,1273004,1273005,1273006,1273007,1273008,1273009,1273010,1273011,1273012,1273013,1273014,1273015,
        1273016,1273017,1273018,1273019,1273020,1273021,1273022,1273023,1273024,1273025,1273026,1273027,1273028,1273029,1273030,1273031,1273032,1273033,1273034,1273035,
        1273036,1273037,1273038,1273039,1273040,1273041,1273042,1273043,1273044,1273045,1273046,1273047,1273048,1273049,1273050,1273051,1273052,1273053,1273055,1273056,
        1273057,1273058,1273059,1273060,1273061,1273062,1273063,1273064,1273065,1273066,1273067,1273068,1273069,1273070,1273071,1273075,1273076,1273077,1273078,1273079,
        1273080,1273082,1273083,1273084,1273086,1273087,1273088,1273090,1273092,1273093,1273095,1273096,1273097,1273098,1273099,1273100,1273101,1273102,1273103,1273104,
        1273105,1273106,1273107,1273108,1273109,1273110,1273111,1273112,1273113,1273114,1273115,1273116,1273117,1273118,1273119,1273120,1273121,1273122,1273123,1273124,
        1273125,1269078,1269095,1269100,1269137,1269285,1269289,1269290,1269297,1269294,1269305,1269302,1269317,1269307,1269321,1269322,1269330,1269333,1269343,1269344,
        1269348,1269355,1269367,1269371,1269376,1269380,1269388,1269393,1269397,1269403,1269406,1269411,1269413,1269422,1269426,1269431,1269435,1269449,1269453,1269462,
        1269464,1269467,1269469,1269470,1269471,1269477,1269479,1269481,1269482,1269552,1269554,1269555,1269557,1269565,1269568,1269573,1269576,1269578,1269580,1269583,
        1269584,1269591,1269592,1269597,1269598,1269600,1269601,1269606,1269607,1269612,1269613,1269616,1269617,1269619,1269621,1269623,1269625,1269629,1269630,1269636,
        1269640,1269645,1269648,1269651,1269652,1269656,1269667,1269686,1269703
    ],
    14 => [
        1181082,1181083,1181084,1181088,1181091,1181094,1181103,1181106,1181110,1181111,1181113,1181114,1181116,1181118,1181120,1181122,1181123,1181124,1181125,1181126,
        1181127,1181128,1181129,1181130,1181131,1181132,1181133,1181134,1181135,1181136,1181138,1181140,1181143,1181144,1181145,1181146,1181147,1181148,1181149,1181150,
        1181151,1181152,1181153,1181154,1181156,1181157,1181158,1181159,1181160,1181161,1181162,1181163,1181164,1181165,1181166,1181167,1181168,1181169,1181170,1181171,
        1181172,1181173,1181174,1181175,1181178,1181179,1181180,1181181,1181182,1180888,1180889,1180900,1180901,1180902,1180904,1180908,1180909,1180911,1180914,1180915,
        1180918,1180933,1180935,1180937,1180938,1180940,1180942,1180943,1180944,1180945,1180946,1180947,1180948,1180949,1180950,1180951,1180952,1180960,1180961,1180962,
        1180963,1180964,1180965,1180966,1180967,1180968,1180969,1180970,1180971,1180972,1180974,1180975,1180976,1180977,1180978,1180979,1180980,1180981,1180982,1180983,
        1180984,1180985,1180986,1180987,1180989,1180990,1180991,1180992,1180993,1180994,1180995,1180996,1180997,1180998,1180999,1181000,1181001,1181002,1181003,1181004,
        1181005,1181006,1181007,1181008,1181009,1181010,1181011,1181014,1181016,1181017,1181022,1181023,1181024,1181025,1181029,1181030,1181031,1181032,1181033,1181035,
        1181036,1181037,1181040,1181041,1181044,1181045,1181046,1181047,1181048,1181049,1181050,1181051,1181052,1181053,1181054,1181055,1181056,1181057,1181058,1181059,
        1181060,1181061,1181062,1181063,1181064,1181065,1181067,1181068,1181071,1181075,1181077,1181079,1181080,1181081,1181183,1181184,1181185,1181186,1181187,1181188,
        1181189,1181190,1181191,1181193,1181194,1181195,1181196,1181197,1181198,1181200,1181201,1181202,1181203,1181204,1181205,1181206,1181207,1181208,1181209,1181210,
        1181211,1181212,1181213,1181214,1181215,1181216,1181217,1181218,1181219,1181220,1181221,1181226,1181228,1181233,1181235,1181236,1181240,1181241,1181242,1181246,
        1181247,1181248,1181249,1181250,1181251,1181252,1181253,1181262,1181263,1181264,1181265,1181266,1181267,1181268,1181269,1181270,1181271,1181272,1181273,1181274,
        1181275,1181276,1181277,1181278,1181279,1181280,1181281,1181282,1181283,1181284,1181285,1181286,1181287,1181288,1181289,1181290,1181291,1181293,1181296,1181299,
        1181301,1181302,1181303,1181306,1181309,1181310,1181311,1181312,1181314,1181317,1181318,1181319,1181320,1181321,1181322,1181323,1181324,1181325,1181326,1181329,
        1181330,1181331,1181332,1181333,1181334,1181335,1181336,1181337,1181338,1181339,1181340,1181341,1182476,1182477,1182478,1182479,1182480,1182481,1182482,1182483,
        1182484,1182485,1182486,1182487,1182488,1182489,1182490,1182491,1182492,1182493,1182494,1182496,1182497,1182498,1182499,1182500,1182501,1182502,1182503,1182506,
        1182507,1182508,1182509,1182510,1182511,1182512,1182513,1182514,1182515,1182516,1182517,1182518,1182519,1182520,1182521,1182522,1182523,1182524,1182525,1182526,
        1182527,1182528,1182529,1182530,1182531,1182532,1182533,1182534,1182535,1182536,1182537,1182538,1182539,1182540,1182541,1182542,1182543,1182544,1182545,1182546,
        1182547,1182548,1182549,1182550,1182551,1182552,1182553,1182554,1182555,1182556,1182557,1182558,1182559,1182560,1182561,1182562,1182563,1182564,1182565,1182566,
        1182567,1182568,1182569,1182570,1182571,1182572,1182573,1182574,1182575,1182578,1182579,1182580,1182581,1182582,1182583,1182584,1182585,1182586,1182587,1182588,
        1182589,1182590,1182591,1182592,1182593,1182594,1182595,1182596,1182597,1182598,1182599,1182600,1182601,1182602,1182603,1182604,1182605,1182606,1182607,1182608,
        1182609,1182610,1182611,1182612,1182613,1182614,1182615,1182616,1182625,1182626,1182627,1182628,1182629,1182630,1182631,1182632,1182633,1182634,1182635,1182636,
        1182637,1182638,1182639,1182640,1182641,1182642,1182643,1182644,1182645,1182646,1182647,1182648,1182649,1182650,1182651,1182652,1182653,1182654,1182655,1182656,
        1182657,1182658,1182659,1182660,1182661,1182662,1182663,1182664,1182665,1182666,1182667,1182668,1182669,1182670,1182671,1182672,1182673,1182674,1182675,1182676,
        1182677,1182678,1182679,1182680,1182681,1182682,1182683,1182684,1182685,1182686,1182687,1182688,1182689,1182690,1182691,1182692,1182693,1182694,1182695,1182696,
        1182697,1182698,1182699,1182700,1182701,1182702,1182703,1182704,1182705,1182708,1182709,1182710,1182711,1182712,1182713,1182714,1182715,1182716,1182717,1182718,
        1182719,1182720,1182721,1182722,1182723,1182724,1182725,1182726,1182727,1182728,1182729,1182730,1182731,1182732,1182733,1182734,1182735,1182736,1182737,1182738,
        1182739,1182740,1182741,1182742,1182743,1182746,1182747,1182748,1182749,1182750,1182751,1182752,1182753,1182754,1182755,1182756,1182757,1182758,1182759,1182760,
        1182761,1182762,1182763,1182764,1182765,1182766,1182767,1182768,1182769,1181425,1181428,1181429,1181430,1181431,1181432,1181433,1181434,1181435,1181436,1181437,
        1181438,1181439,1181440,1181441,1181442,1181443,1181446,1181447,1181450,1181451,1181452,1181454,1181456,1181457,1181458,1181459,1181460,1181461,1181462,1181463,
        1181464,1181465,1181466,1181467,1181468,1181469,1181470,1181471,1181472,1181473,1181474,1181475,1181476,1181478,1181479,1181480,1181481,1181482,1181483,1181484,
        1181485,1181494,1181495,1181496,1181497,1181499,1181500,1181501,1181502,1181503,1181504,1181613,1181704,1181713,1181803,1181812,1181813,1181902,1181916,1181917,
        1181918,1181919,1181920,1181921,1181923,1181924,1181930,1181959,1181960,1181961,1181963,1181964,1181965,1181966,1181967,1181968,1181970,1181971,1181972,1181973,
        1181974,1181975,1181976,1181977,1181978,1181979,1181980,1181981,1181982,1181983,1181984,1181985,1181986,1181987,1181988,1181989,1181990,1181991,1181992,1181993,
        1181994,1181995,1181997,1181998,1181999,1182000,1182001,1182003,1182004,1182005,1182006,1182007,1182008,1182009,1182010,1182011,1182012,1182013,1182014,1182015,
        1182016,1182017,1182018,1182019,1182020,1182021,1182022,1182023,1182024,1182025,1182026,1182029,1182030,1182031,1182032,1182033,1182034,1182035,1182036,1182037,
        1182039,1182040,1182041,1182042,1182043,1182044,1182050,1182051,1182053,1182055,1182070,1182084,1182111,1182122,1182124,1182125,1182126,1182127,1182128,1182129,
        1182131,1182132,1182133,1182134,1182135,1182136,1182138,1182140,1182141,1182143,1182144,1182145,1182146,1182147,1182148,1182149,1182150,1182152,1182154,1182157,
        1182160,1182166,1182169,1182170,1182171,1182173,1182174,1182175,1182176,1182177,1182178,1182179,1182180,1182181,1182182,1182183,1182185,1182186,1182187,1182188,
        1182189,1182190,1182191,1182192,1182193,1182194,1182195,1182196,1182198,1182199,1182200,1182201,1182202,1182204,1182205,1182208,1182213,1182219,1182223,1182228,
        1182231,1182235,1182237,1182240,1182242,1182243,1182244,1182245,1182248,1182250,1182251,1182252,1182253,1182254,1182256,1182258,1182260,1182261,1182264,1182265,
        1182266,1182267,1182270,1182272,1182273,1182276,1182278,1182279,1182280,1182281,1182282,1182283,1182285,1182287,1182288,1182289,1182290,1182291,1182292,1182293,
        1182294,1182295,1182296,1182297,1182298,1182299,1182300,1182301,1182303,1182306,1182307,1182308,1182309,1182311,1182312,1182315,1182317,1182319,1182322,1182325,
        1182326,1182327,1182328,1182329,1182330,1182331,1182332,1182333,1182334,1182335,1182336,1182338,1182339,1182340,1182341,1182342,1182343,1182344,1182345,1182346,
        1182347,1182348,1182349,1182350,1182351,1182352,1182353,1182354,1182355,1182356,1182357,1182358,1182359,1182360,1182361,1182362,1182363,1182364,1182365,1182366,
        1182367,1182368,1182369,1182370,1182371,1182372,1182373,1182374,1182375,1182376,1182377,1182379,1182380,1182381,1182382,1182383,1182384,1182387,1182388,1182389,
        1182390,1182393,1182396,1182399,1182402,1182405,1182409,1182413,1182414,1182415,1182416,1182417,1182418,1182419,1182420,1182421,1182422,1182423,1182424,1182425,
        1182426,1182428,1182429,1182430,1182431,1182432,1182433,1182434,1182435,1182436,1182437,1182438,1182439,1182440,1182441,1182442,1182443,1182444,1182445,1182446,
        1182447,1182448,1182449,1182450,1182451,1182452,1182453,1182454,1182455,1182456,1182457,1182458,1182459,1182460,1182461,1182462,1182463,1182464,1182465,1182466,
        1182467,1182468,1182469,1182470,1182471,1182472,1182473,1182474,1182475,1182770,1182771,1182772,1182776,1182777,1182778,1182779,1182780,1182781,1182782,1182783,
        1182784,1182785,1182786,1182787,1182788,1182789,1182790,1182791,1182792,1182793,1182795,1182796,1182797,1182798,1182799,1182800,1182801,1182802,1182803,1182804,
        1182805,1182806,1182807,1182808,1182809,1182810,1182811,1182812,1182813,1182814,1182815,1182816,1182817,1182818,1182819,1182820,1182821,1182822,1182823,1182824,
        1182825,1182826,1182827,1182828,1182829,1182830,1182831,1182832,1182833,1182834,1182835,1182836,1182837,1182838,1182839,1182840,1182841,1182842,1182843,1182844,
        1182845,1182846,1182847,1182848,1182849,1182850,1181342,1181343,1181344,1181345,1181346,1181349,1181350,1181351,1181352,1181353,1181354,1181355,1181356,1181357,
        1181358,1181359,1181360,1181362,1181363,1181364,1181365,1181366,1181367,1181369,1181370,1181371,1181372,1181373,1181374,1181375,1181376,1181377,1181378,1181379,
        1181380,1181381,1181382,1181383,1181384,1181385,1181386,1181387,1181388,1181389,1181390,1181391,1181393,1181394,1181395,1181396,1181397,1181398,1181399,1181400,
        1181401,1181402,1181403,1181404,1181405,1181407,1181408,1181409,1181410,1181411,1181412,1181413,1181414,1181417,1181418,1181419,1181421,1181423,1181424,1183214,
        1183215,1183216,1183217,1183218,1183219,1183224,1183231,1183237,1183243,1183244,1183249,1183259,1183260,1183261,1183262,1183263,1183264,1183265,1183266,1183267,
        1183268,1183269,1183270,1183252,1183258,1183271,1183272,1183278,1183279,1183280,1183284,1183285,1183286,1183287,1183288,1183289,1183291,1183292,1183295,1183302,
        1183304,1183305,1183307,1183308,1183345
    ],
};

$log->out('START');

for my $shard (keys %$shard2id) {
    my $msg_guard = $log->msg_prefix_guard("[shard_$shard]");
    for my $ids_chunk (chunks($shard2id->{$shard}, $DELETE_CHUNK)) {
        $log->out("delete chunk of ids:", $ids_chunk);
        my $deleted_cnt = do_delete_from_table(PPC(shard => $shard), 'moderation_cmd_queue', where => {cmd => 'copyCampModerateInfo', id => $ids_chunk}) + 0;
        $log->out("deleted $deleted_cnt copyCampModerateInfo cmds");
    }
}

$log->out('FINISH');
