#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "несколько секунд",
      comment => "Можно перезапускать"
    }
  ],
  approved_by => 'gukserg'
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;

use my_inc '..';

use ScriptHelper;
use Settings;

my $DELETE_CHUNK = 500;

my $shard2id = {
    13 => [
        1273127,1273129,1273130,1273131,1273132,1273133,1273134,1273135,1273136,1273137,1273138,1273139,1273140,1273141,1273142,1273143,1273144,1273145,
        1273146,1273148,1273149,1273151,1273152,1273162,1273226,1273230,1273235,1273265,1273269,1273275,1273281,1273286,1273293,1273294,1273295,1273296,
        1273298,1273299,1273300,1273301,1273302,1273305,1273306,1273398,1273399,1273400,1273401,1273402,1273403,1273404,1273405,1273406,1273410,1273417,
        1273422,1273423,1273425,1273434,1273446,1273448,1273449,1273450,1273453,1273455,1273456,1273459,1273461,1273463,1273464,1273466,1273470,1273471,
        1273474,1273475,1273476,1273477,1273479,1273480,1273481,1273482,1273483,1273485,1273487,1273488,1273489,1273490,1273491,1273492,1273493,1273496,
        1273497,1273498,1273499,1273500,1273501,1273502,1273503,1273504,1273506,1273507,1273510,1273511,1273512,1273513,1273514,1273515,1273516,1273518,
        1273519,1273520,1273521,1273522,1273524,1273528,1273557,1273613,1273614,1273615,1273616,1273617,1273618,1273619,1273620,1273621,1273622,1273623,
        1273624,1273625,1273626,1273627,1273628,1273629,1273632,1273633,1273634,1273635,1273636,1273637,1273639,1273640,1273641,1273642,1273643,1273644,
        1273646,1273647,1273648,1273649,1273691,1273697,1273700,1273701,1273704,1273705,1273707,1273711,1273712,1273714,1273716,1273717,1273718,1273719,
        1273720,1273721,1273723,1273726,1273729,1273732,1273734,1273735,1273737,1273738,1273739,1273741,1273742,1273744,1273748,1273751,1273752,1273754,
        1273755,1273756,1273757,1273758,1273759,1273760,1273761,1273762,1273763,1273765,1273766,1273767,1273768,1273769,1273770,1273771,1273772,1273773,
        1273774,1273424,1273447,1273452,1273458,1273462,1273467,1273638,1273645,1273650,1273696,1273703,1273706,1273733,1273736,1273740,1273743,1273745,
        1273753,1273809,1273815,1273820,1273824,1273827,1273835,1273838,1273839,1273840,1273841,1273842,1273844,1273851,1273862,1273880,1273881,1273895,
        1273978,1273979,1273981,1273984,1273985,1273986,1273989,1273990,1273992,1273993,1273994,1273995,1274022,1274027,1274030,1274031,1274036,1274038,
        1274043,1274044,1274045,1274052,1274055,1274056,1274057,1274058,1274059,1274060,1274061,1274062,1274064,1274065,1274066,1274070,1274076,1274078,
        1274084,1274088,1274103,1274105,1274107,1274108,1274115,1274116,1274117,1274118,1274119,1274120,1274121,1274122,1274123,1274126,1274131,1274134,
        1274135,1274137,1274138,1274140,1274177,1274182,1274185,1274186,1274187,1274190,1274191,1274192,1274222,1274223,1274226,1274229,1274242,1274248,
        1274276,1274280,1274284,1274286,1274298,1274315,1274323,1274324,1274327,1274328,1274329,1274400,1274401,1274402,1274403,1274404,1274405,1274406,
        1274408,1274409,1274410,1274411,1274412,1274413,1274819,1274820,1274825,1274836,1274844,1274853,1274912,1274936
    ],
    14 => [
        1185824,1185830,1185831,1185832,1185834,1185833,1185837,1185838,1185839,1185842,1185841,1185840,1185844,1185845,1185846,1185847,1185848,1185849,
        1185850,1185851,1185852,1185853,1185867,1185854,1185880,1185876,1185882,1185883,1185884,1185885,1185887,1185888,1185886,1185889,1185891,1185890,
        1185892,1185893,1185895,1185894,1185897,1185898,1185896,1185899,1185900,1185902,1185901,1185903,1185904,1185906,1185910,1185967,1185965,1185971,
        1185973,1185974,1185975,1185976,1185977,1185979,1185978,1185981,1185980,1185983,1185984,1185986,1185985,1185989,1185987,1185991,1185996,1185997,
        1185993,1185998,1185999,1186000,1186001,1186002,1186003,1186005,1186004,1186006,1186008,1186007,1186009,1186014,1186013,1186010,1186015,1186016,
        1186017,1186021,1186020,1186024,1186023,1186027,1186028,1186030,1186031,1186032,1186034,1186035,1186033,1186038,1186039,1186040,1186045,1186043,
        1186042,1186044,1186046,1186047,1186048,1186051,1186049,1186050,1186053,1186052,1186055,1186054,1186056,1186057,1186058,1186059,1186067,1186060,
        1186066,1186068,1186070,1186074,1186075,1186079,1186083,1186084,1186088,1186089,1186087,1186090,1186091,1186092,1186096,1186094,1186093,1186095,
        1186097,1186098,1186099,1186100,1186101,1186102,1186104,1186108,1186103,1186105,1186111,1186116,1186117,1186121,1186122,1186130,1186126,1186136,
        1186133,1186137,1186142,1186141,1186143,1186145,1186146,1186148,1186147,1186149,1186150,1186151,1186152,1186154,1186153,1186155,1186156,1186157,
        1186158
    ],
};

$log->out('START');

for my $shard (keys %$shard2id) {
    my $msg_guard = $log->msg_prefix_guard("[shard_$shard]");
    for my $ids_chunk (chunks($shard2id->{$shard}, $DELETE_CHUNK)) {
        $log->out("delete chunk of ids:", $ids_chunk);
        my $deleted_cnt = do_delete_from_table(PPC(shard => $shard), 'moderation_cmd_queue', where => {cmd => 'copyCampModerateInfo', id => $ids_chunk}) + 0;
        $log->out("deleted $deleted_cnt copyCampModerateInfo cmds");
    }
}

$log->out('FINISH');
