#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "несколько секунд",
      comment => "Можно перезапускать"
    }
  ],
  approved_by => 'gukserg'
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;

use my_inc '..';

use ScriptHelper;
use Settings;

my $DELETE_CHUNK = 500;

my $shard2id = {
    14 => [
        1188202,1188203,1188374,1188376,1188377,1188378,1188379,1188380,1188381,1188382,1188383,1188384,1188385,1188386,1188387,1188276,1188281,
        1188282,1188283,1188285,1188286,1188287,1187199,1187197,1187203,1187202,1187206,1187204,1187209,1187205,1187207,1187210,1187212,1187215,
        1187214,1187213,1187216,1187225,1187223,1187220,1187221,1187224,1187239,1187226,1187241,1187240,1187242,1187243,1187250,1187244,1187245,
        1187251,1187246,1187249,1187252,1187253,1187258,1187256,1187259,1187261,1187263,1187260,1187262,1187265,1187266,1187268,1187267,1187321,
        1187327,1187332,1187335,1187336,1187338,1187342,1187345,1187346,1187355,1187362,1187380,1187394,1187433,1187434,1187440,1187452,1187454,
        1187455,1187458,1187461,1187471,1187474,1187479,1187481,1187483,1187484,1187488,1187495,1187498,1187500,1187512,1187515,1187516,1187517,
        1187518,1187519,1187520,1187521,1187548,1187549,1187551,1187552,1187553,1187556,1187557,1187747,1187938,1187939,1187940,1187941,1187942,
        1187943,1187946,1187954,1187955,1187957,1187959,1187962,1187963,1187968,1187969,1187971,1187986,1188033
    ],
};

$log->out('START');

for my $shard (keys %$shard2id) {
    my $msg_guard = $log->msg_prefix_guard("[shard_$shard]");
    for my $ids_chunk (chunks($shard2id->{$shard}, $DELETE_CHUNK)) {
        $log->out("delete chunk of ids:", $ids_chunk);
        my $deleted_cnt = do_delete_from_table(PPC(shard => $shard), 'moderation_cmd_queue', where => {cmd => 'copyCampModerateInfo', id => $ids_chunk}) + 0;
        $log->out("deleted $deleted_cnt copyCampModerateInfo cmds");
    }
}

$log->out('FINISH');
