#!/usr/bin/env perl

=head1 DEPLOY

# .migr
{
  approved_by => 'ppalex',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "пару минут на первом шаде, до 30с на другие шарды"
    }
  ]
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;

use ShardingTools;
use Yandex::HashUtils qw/hash_cut/;
use Yandex::ListUtils qw/chunks/;

my $UPDATE_CHUNK = 1000;

my @SHARDS;

$log->out('START');
extract_script_params(
    'shard-id:i' => \@SHARDS,
);
@SHARDS = ppc_shards() if !@SHARDS;

for my $shard (@SHARDS) {
    $log->out("Processing shard $shard");
    my $cids_hash = get_hashes_hash_sql(PPC(shard => $shard), "SELECT c.cid, c.sum_last, c.sum_to_pay
        FROM campaigns c
            LEFT JOIN camp_options co ON co.cid = c.cid
        WHERE statusEmpty = 'Yes'
            AND sum = 0
            AND OrderID = 0
            AND (co.create_time < now() - INTERVAL 14 DAY)
            AND (c.lastchange < now() - INTERVAL 14 DAY)
            AND (c.sum_last > 0 OR c.sum_to_pay > 0)"
    );
    next unless %$cids_hash;
    my $cids = [sort {$a <=> $b} keys %$cids_hash];
    for my $chunk (chunks($cids, $UPDATE_CHUNK)) {
        $log->out(["backup data", hash_cut($cids_hash, @$chunk)]);
        do_update_table(PPC(shard => $shard), "campaigns", {sum_last => 0, sum_to_pay => 0}, where => {cid => $chunk, lastchange__lt => '2018-10-09'});
    }
}

$log->out('FINISH');
