#!/usr/bin/env perl

=head1 DEPLOY

# .migr
{
  approved_by => 'gerdler',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "на dev7 95 сек"
    }
  ]
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;

use ShardingTools;

$log->out('START');

for my $shard (ppc_shards()) {
    $log->out("Processing shard $shard");
    my $cids = get_one_column_sql(PPC(shard => $shard), ['SELECT cid FROM campaigns',
        where => {type => "mobile_content", strategy_name=> "autobudget", _TEXT => 'strategy_data->"$.goal_id"="4100000000"' }]
    );
    $log->out(["cids", $cids]);
    my $updated_rows = do_sql(PPC(shard => $shard), 
      ['update campaigns set strategy_data=JSON_REPLACE(strategy_data, "$.goal_id", "4"), statusBsSynced="No"', 
      where => { cid => $cids, strategy_name => "autobudget", _TEXT => 'strategy_data->"$.goal_id"="4100000000"'}]);
    $log->out(["count", $updated_rows]);
}

$log->out('FINISH');
