#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => '1 sec',
    }
  ],
  approved_by => 'zhur'
}

=cut

use Direct::Modern;

use my_inc '..';

use RBAC2::Extended;
use RBACDirect qw/ rbac_save_camp_for_agency /;

use ScriptHelper;
use Settings;

$log->out('START');

my $agency_uid = 87417627;
my $client_uid = 360133279;
my $cid        = 37977787;

my $rbac = RBAC2::Extended->get_singleton( $agency_uid );

my $res = rbac_save_camp_for_agency( $rbac, $agency_uid, $client_uid, $cid );
$log->out("Failed to assign camp to agency in RBAC: $res") if $res;

$log->out('FINISH');
