#!/usr/bin/env perl

=head1 DEPLOY

# .migr
{
  approved_by => 'liosha',
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "от 10 минут до часа",
      comment => "можно перезапускать",
    }
  ]
}

=cut

use Direct::Modern;
use my_inc '..';

use Settings;
use ScriptHelper;

use ShardingTools;
use Yandex::DBTools;
use Yandex::Retry qw/relaxed_guard/;
use Yandex::ListUtils qw/nsort chunks/;

use Campaign;
use Direct::Model::Campaign;
use BS::ResyncQueue qw/bs_resync/;


my $OLD_ID = 7;
my $EMPTY_MG = qq'[{"goal_id": "$OLD_ID"}]';
my $UPDATE_CHUNK_SIZE = 500;

$log->out('START');

extract_script_params(
    'shard-id=i' => \my @shards,
    'cid=i' => \my @cids,
);

@shards = ppc_shards()  if !@shards;

for my $shard (@shards) {
    $log->out("Processing shard $shard");

    $log->out("Fixing empty values");
    # записей может быть несколько десятков тысяч
    my $cids_to_fix = get_one_column_sql(PPC(shard => $shard), [
            'SELECT cid FROM camp_options',
            WHERE => {
                meaningful_goals__dont_quote => qq{cast('$EMPTY_MG' as json)},
                (@cids ? (cid => \@cids) : ()),
            },
            'ORDER BY cid',
        ]);
    $log->out(sprintf "%d empty values found", scalar @$cids_to_fix);

    for my $chunk (chunks($cids_to_fix, $UPDATE_CHUNK_SIZE)) {
        my $updated_cnt = do_update_table(PPC(shard => $shard), 'camp_options',
            { meaningful_goals => undef },
            where => {
                cid => $chunk,
                meaningful_goals__dont_quote => qq{cast('$EMPTY_MG' as json)},
            },
        );
        bs_resync([ map {+{cid => $_}} @$chunk ]);
        $log->out(sprintf "fixed %d campaigns: (@$chunk)", $updated_cnt);
    }

    $log->out("Fixing engaged session goal_id");
    # таких записей должно остаться в пределах нескольких сотен, поэтому одним запросом
    my $mg_by_cid = get_hash_sql(PPC(shard => $shard), [
        'SELECT cid, meaningful_goals
        FROM camp_options',
        WHERE => {
            meaningful_goals__contains => qq{"$OLD_ID"},
            (@cids ? (cid => \@cids) : ()),
        },
        'ORDER BY cid',
    ]);
    $log->out(sprintf 'got %d records', scalar keys %$mg_by_cid);

    for my $cid (nsort keys %$mg_by_cid) {
        my $rg = relaxed_guard times => 1;

        my $old_mg = $mg_by_cid->{$cid};
        my $new_mg =
            Direct::Model::Campaign::_serialize_meaningful_goals(
                Campaign::preprocess_meaningful_goals(
                    Direct::Model::Campaign::_deserialize_meaningful_goals($old_mg)
                ));

        $log->out(sprintf "cid $cid:  $old_mg  -->  %s", $new_mg || '<null>');
        do_update_table(PPC(shard => $shard), 'camp_options',
            { meaningful_goals => $new_mg },
            where => {
                cid => $cid,
                meaningful_goals__dont_quote => qq{cast('$old_mg' as json)},
            },
        );
        bs_resync([{cid => $cid}]);
    }
}

$log->out('FINISH');
