#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "пару секунд",
      comment => "скопировать файл  ppcdev2:/var/www/beta.hrustyashko.9122/demography_multipliers.txt и применять так 
        deploy/20181023_fix_demography_multiplier.pl demography_multipliers.txt"
    }
  ],
  approved_by => 'hrustyashko'
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper 'Yandex::Log' => [date_suf => "%Y%m%d"];
use Settings;
use File::Slurp qw/read_file/;
use JSON qw/from_json/;
use List::Util qw/first/;


my $DRY_RUN;
extract_script_params('dry-run|n' => \$DRY_RUN);

$log->out('START');
if ($DRY_RUN) {
    $log->out("dry-run mode");
}

my @multiplies = read_file($ARGV[0], binmode => ':utf8', chomp => 1);
my $line = 0;
for my $multiplier_json (@multiplies) {
    $line++;
    my $expected_multiplier;
    eval {
        $expected_multiplier = from_json($multiplier_json);
    };
    if ($@) {
        $log->out("Invalid json at line " . $line);
        next;
    }

    my $actual_multipliers = get_all_sql(PPC(pid => $expected_multiplier->{adgroup_id}),
                                         ["SELECT demography_multiplier_value_id AS dem_mult_id, gender, age, multiplier_pct AS pct FROM demography_multiplier_values",
                                          WHERE => {hierarchical_multiplier_id => $expected_multiplier->{h_mult_id}}]);

    my $actual_multiplier = first { $expected_multiplier->{dem_mult_id} == $_->{dem_mult_id} } @$actual_multipliers;
    if (!defined $actual_multiplier) {
        $log->out("The isn't demography multiplier; skip pid=" . $expected_multiplier->{adgroup_id});
        next;
    }

    my $more_multi = first {
        $_->{dem_mult_id} != $actual_multiplier->{dem_mult_id}
        && $_->{gender} eq $actual_multiplier->{gender}
    } @$actual_multipliers;

    if (defined $more_multi) {
        $log->out("The are a'lot of multipliers; skip pid=" . $expected_multiplier->{adgroup_id});
        next;
    }

    my @changed = grep {

        defined $actual_multiplier->{$_} && !defined $expected_multiplier->{$_}
        || !defined $actual_multiplier->{$_} && defined $expected_multiplier->{$_}
        || ($expected_multiplier->{$_} // '') ne ($actual_multiplier->{$_} // '')

    } qw/dem_mult_id gender pct/;

    if (@changed) {
        $log->out(sprintf "Fields %s changed; skip pid=%d", join(",", @changed), $expected_multiplier->{adgroup_id});
        next;
    }

    if (defined $actual_multiplier->{age}) {
        $log->out("Age already changed; skip pid=" . $expected_multiplier->{adgroup_id});
        next;
    }

    if (!$DRY_RUN) {
        do_update_table(PPC(pid => $expected_multiplier->{adgroup_id}),
            'demography_multiplier_values',
             {age => $expected_multiplier->{age}},
             where => {
                 demography_multiplier_value_id => $actual_multiplier->{dem_mult_id},
                 age__is_null => 1,
                 gender => $actual_multiplier->{gender},
                 multiplier_pct => $actual_multiplier->{pct},
             });
    }    
    $log->out(sprintf "Set new age %s for dem_mult_id %d", $expected_multiplier->{age}, $actual_multiplier->{dem_mult_id});
}

$log->out('FINISH');

