#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'after',
      time_estimate => "секунда-две",
    }
  ],
  approved_by => 'ppalex'
}

=head1 comment

bid получали так:
dbs-sql pr:ppchouse:logs "select visitParamExtractUInt(insert_data, 'ClientID') AS ClientID , arrayJoin(ids) as bid from dbshards_ids where key = 'bid' and log_date = toDate('2018-10-17') and bid in (...)FORMAT JSONEachRow > file"

другие ключи - схожими запросами
select arrayJoin(ids) as pid, visitParamExtractUInt(insert_data, 'ClientID') AS ClientID from dbshards_ids where key = 'pid' and log_date = toDate('2018-10-17') and pid in (35330233
27, 3533024428, 3533031849, 3533034221, 3533034251) FORMAT JSONEachRow

select arrayJoin(ids) as banner_images_pool_id, visitParamExtractUInt(insert_data, 'ClientID') AS ClientID from dbshards_ids where key = 'banner_images_pool_id' and log_date BETWEEN toDate('2018-10-17') AND toDate('2018-10-18') and banner_images_pool_id in (302893335,302893595,302893668,302895133,302895137,302895139,302895142,302895146,302895158,302895184,302895189,302895191,302895199,302895213,302895226,302895250,302896885,302897191,302897322,302897417,302897417,302897457) FORMAT JSONEachRow

=cut

use Direct::Modern;

use JSON;
use Path::Tiny;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;

my $pids_data =  q/[
{"pid":"3533023327","ClientID":"23836340"},
{"pid":"3533024428","ClientID":"48115050"},
{"pid":"3533031849","ClientID":"49667184"},
{"pid":"3533034221","ClientID":"4182683"},
{"pid":"3533034251","ClientID":"48784482"}
]/;

my $pool_id_data = q/[
{"banner_images_pool_id":"302893595","ClientID":"303569"},
{"banner_images_pool_id":"302893668","ClientID":"303569"},
{"banner_images_pool_id":"302895133","ClientID":"48578355"},
{"banner_images_pool_id":"302895137","ClientID":"48578355"},
{"banner_images_pool_id":"302895139","ClientID":"48578355"},
{"banner_images_pool_id":"302895142","ClientID":"48578355"},
{"banner_images_pool_id":"302895146","ClientID":"48578355"},
{"banner_images_pool_id":"302895158","ClientID":"48578355"},
{"banner_images_pool_id":"302895184","ClientID":"48578355"},
{"banner_images_pool_id":"302895189","ClientID":"48578355"},
{"banner_images_pool_id":"302895191","ClientID":"48578355"},
{"banner_images_pool_id":"302895199","ClientID":"48578355"},
{"banner_images_pool_id":"302895213","ClientID":"48578355"},
{"banner_images_pool_id":"302895226","ClientID":"4033790"},
{"banner_images_pool_id":"302895250","ClientID":"49448645"},
{"banner_images_pool_id":"302896885","ClientID":"39774086"},
{"banner_images_pool_id":"302897191","ClientID":"39561425"},
{"banner_images_pool_id":"302897322","ClientID":"2268367"},
{"banner_images_pool_id":"302897417","ClientID":"49930629"},
{"banner_images_pool_id":"302897457","ClientID":"49563420"},
{"banner_images_pool_id":"302893335","ClientID":"47706923"}
]/;

$log->out('START');

$log->out("load bids");
my $data_path = my_inc::path('./20181026_fill_lost_metabase_data.data');
my @data = path($data_path)->lines({ chomp => 1}) or $log->die("Can't open data file $data_path: $@");
@data = map { [ @{$_}{qw/bid ClientID/} ]  } map { from_json($_) } @data;

$log->out("insert into shard_inc_bid");
my $res = do_mass_insert_sql(PPCDICT, 'insert ignore into shard_inc_bid (bid, ClientID) VALUES %s', \@data);
$log->out("affected $res rows");

my @pids = map { [ @{$_}{qw/pid ClientID/} ] } @{ from_json($pids_data) };
$log->out("insert into shard_inc_pid");
$res = do_mass_insert_sql(PPCDICT, 'insert ignore into shard_inc_pid (pid, ClientID) VALUES %s', \@pids);
$log->out("affected $res rows");

my @pool_id = map { [ @{$_}{qw/banner_images_pool_id ClientID/} ] } @{ from_json($pool_id_data) };
$log->out("insert shard_inc_banner_images_pool_id");
$res = do_mass_insert_sql(PPCDICT, 'insert ignore shard_inc_banner_images_pool_id(banner_images_pool_id, ClientID) VALUES %s', \@pool_id);
$log->out("affected $res rows");

$log->out("insert into shard_inc_tag_id");
$res = do_insert_into_table(PPCDICT, "shard_inc_tag_id", {"tag_id" =>"32842475","ClientID"=>"44926534"}, ignore => 1);
$log->out("inserted id $res");

$log->out('FINISH');

