#!/usr/bin/perl

=head1 DEPLOY

# .migr
{
  tasks => [
    {
      type => 'script',
      when => 'instructions',
      instructions => "
                  перед запуском нужно привезти файл с маппингом
                  scp ppcdev5:/home/aleran/adgroups_with_wrong_geo.txt .
                  путь к этому файлу нужно будет указать в параметрах запуска,
                  ./20181129_fix_translocal_geo.pl adgroups_with_wrong_geo.txt",
      time_estimate => "на devtest 1 минута",
      comment => "можно перезапускать"
    }
  ],
  approved_by => 'liosha'
}

=head1 DESCRIPTION

    Читает из файла json ошибочных групп. Файл в виде списка json. один объект {"adgroup_id": NNN, "expected_geo": Str, "fixed_geo": Str}
    Заменяет гео группы так, что: Если гео группы равно expectedGeo, то заменяем на fixedGeo, иначе пропускаем

    Параметры
        <file> - путь к файлу

=cut

use Direct::Modern;

use Yandex::Retry qw/relaxed/;
use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::ListUtils qw(nsort);

use my_inc '..';

use ScriptHelper 'Yandex::Log' => 'messages';
use Settings;

use JSON;
use Path::Tiny;

$log->out('START');

my $filename = $ARGV[0];
unless ($filename && -f $filename) {
    usage();
}

my $SLEEP_COEF = 2;
my $PROCESS_CHUNK_SIZE = 1000;

my %adgroup_id_to_geo = map {$_->{adgroup_id} => $_} @{from_json(path($filename)->slurp_utf8)};

for my $chunk (sharded_chunks( pid => [ nsort keys %adgroup_id_to_geo ], chunk_size => $PROCESS_CHUNK_SIZE)) {
    my $shard = $chunk->{shard};
    my $adgroup_ids = $chunk->{pid};
    my @chuncked_adgroups = map {$adgroup_id_to_geo{$_}} @$adgroup_ids;
    $log->msg_prefix("[shard $shard]");

    relaxed times => $SLEEP_COEF, sub {
            do_in_transaction {
                    my $db_adgroups = get_hashes_hash_sql(PPC(shard => $shard), [
                            q{SELECT pid, cid, geo FROM phrases p}
                            , where => {
                                'p.pid' =>  $adgroup_ids,
                            },
                            'FOR UPDATE'
                        ]);
                    my %adgroups_for_update = ();
                    my %campaign_ids_for_update = ();

                    for my $group (@chuncked_adgroups) {
                        my $adgroup_id = $group->{adgroup_id};
                        if (!$db_adgroups->{$adgroup_id}) {
                            $log->out("skip not in db adgroup_id - $adgroup_id");
                            next;
                        }
                        if ($db_adgroups->{$adgroup_id}->{geo} eq $adgroup_id_to_geo{$adgroup_id}->{expected_geo}) {
                            $adgroups_for_update{$adgroup_id} = $adgroup_id_to_geo{$adgroup_id}->{fixed_geo};
                            $campaign_ids_for_update{$db_adgroups->{$adgroup_id}->{cid}} = undef;
                        } else {
                            $log->out("skip adgroup_id - $adgroup_id ; expected_geo - $adgroup_id_to_geo{$adgroup_id}->{expected_geo} ;"
                                . " real_geo - $db_adgroups->{$adgroup_id}->{geo} ; tried to $adgroup_id_to_geo{$adgroup_id}->{fixed_geo}");
                        }
                    }
                    $log->out("update data chunk for adgroup_ids: " . join(',', keys %adgroups_for_update) . " with size " . scalar keys %adgroups_for_update);

                    my $update_adgroups_res = int do_update_table(PPC(shard => $shard), 'phrases',
                            { 'geo__dont_quote' => sql_case(pid => \%adgroups_for_update),
                                'statusBsSynced' => 'No',
                                'LastChange__dont_quote' => 'NOW()',
                                'statusShowsForecast' => 'New'
                            },
                            where => {
                                pid   =>  [keys %adgroups_for_update]
                            }
                        );
                    $log->out("updated adgroups: $update_adgroups_res");

                    my $update_campaigns_res = int do_update_table(PPC(shard => $shard), 'campaigns',
                            { 'autobudgetForecastDate' => undef,
                                'LastChange__dont_quote' => 'NOW()',
                            },
                            where => {
                                cid   =>  [keys %campaign_ids_for_update]
                            }
                        );
                    $log->out("updated campaigns: $update_campaigns_res");
                };

        };
    @chuncked_adgroups = ();
}
$log->msg_prefix('');
$log->out('FINISH');

